/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class CloneIdiom
extends DismantleBytecode
implements Detector,
Constants2 {
    boolean hasCloneMethod;
    MethodAnnotation cloneMethodAnnotation;
    boolean referencesCloneMethod;
    boolean invokesSuperClone;
    boolean isFinal;
    boolean check;
    boolean implementsCloneableDirectly;
    private BugReporter bugReporter;
    private AnalysisContext analysisContext;

    public CloneIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void setAnalysisContext(AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals("clone") && this.getMethodSig().startsWith("()")) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 183 && this.getNameConstantOperand().equals("clone") && this.getSigConstantOperand().startsWith("()")) {
            this.invokesSuperClone = true;
        }
    }

    public void visit(JavaClass obj) {
        this.implementsCloneableDirectly = false;
        this.invokesSuperClone = false;
        this.check = false;
        this.isFinal = obj.isFinal();
        if (obj.isInterface()) {
            return;
        }
        if (obj.isAbstract()) {
            return;
        }
        String[] interface_names = obj.getInterfaceNames();
        for (int i = 0; i < interface_names.length; ++i) {
            if (!interface_names[i].equals("java.lang.Cloneable")) continue;
            this.implementsCloneableDirectly = true;
            break;
        }
        try {
            JavaClass superClass = obj.getSuperClass();
            if (superClass != null && Repository.implementationOf((JavaClass)superClass, (String)"java.lang.Cloneable")) {
                this.implementsCloneableDirectly = false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.hasCloneMethod = false;
        this.referencesCloneMethod = false;
        this.check = true;
        super.visit(obj);
    }

    public void visitAfter(JavaClass obj) {
        if (!this.check) {
            return;
        }
        if (this.implementsCloneableDirectly && !this.hasCloneMethod && !this.referencesCloneMethod) {
            this.bugReporter.reportBug(new BugInstance("CN_IDIOM", 2).addClass((PreorderVisitor)this));
        }
        if (this.hasCloneMethod && !this.invokesSuperClone && !this.isFinal && obj.isPublic()) {
            this.bugReporter.reportBug(new BugInstance("CN_IDIOM_NO_SUPER_CALL", obj.isPublic() || obj.isProtected() ? 2 : 3).addClass((PreorderVisitor)this).addMethod(this.cloneMethodAnnotation));
        }
    }

    public void visit(ConstantNameAndType obj) {
        String methodName = obj.getName(this.getConstantPool());
        String methodSig = obj.getSignature(this.getConstantPool());
        if (!methodName.equals("clone")) {
            return;
        }
        if (!methodSig.startsWith("()")) {
            return;
        }
        this.referencesCloneMethod = true;
    }

    public void visit(Method obj) {
        if (obj.isAbstract()) {
            return;
        }
        if (!obj.isPublic()) {
            return;
        }
        if (!this.getMethodName().equals("clone")) {
            return;
        }
        if (!this.getMethodSig().startsWith("()")) {
            return;
        }
        this.hasCloneMethod = true;
        this.cloneMethodAnnotation = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
        ExceptionTable tbl = obj.getExceptionTable();
    }
}

