/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.ExtendedTypes;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.StandardTypeMerger;
import edu.umd.cs.findbugs.ba.TypeAnalysis;
import edu.umd.cs.findbugs.ba.TypeDataflow;
import edu.umd.cs.findbugs.ba.TypeFrame;
import edu.umd.cs.findbugs.ba.TypeFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.TypeMerger;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindRefComparison
implements Detector,
ExtendedTypes {
    private static final boolean DEBUG = Boolean.getBoolean("frc.debug");
    private static final boolean REPORT_ALL_REF_COMPARISONS = Boolean.getBoolean("findbugs.refcomp.reportAll");
    private static final HashSet<String> suspiciousSet = new HashSet();
    private static final BitSet invokeInstanceSet;
    private static final BitSet prescreenSet;
    private static final byte T_DYNAMIC_STRING = 100;
    private static final byte T_STATIC_STRING = 101;
    private static final String STRING_SIGNATURE = "Ljava/lang/String;";
    private static final Type dynamicStringTypeInstance;
    private static final Type staticStringTypeInstance;
    private BugReporter bugReporter;
    private AnalysisContext analysisContext;
    private BugInstance stringComparison;
    private BugInstance refComparison;
    static boolean sawStringIntern;

    public FindRefComparison(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void setAnalysisContext(AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass jclass = classContext.getJavaClass();
        Method[] methodList = jclass.getMethods();
        sawStringIntern = false;
        for (int i = 0; i < methodList.length; ++i) {
            BitSet bytecodeSet;
            Method method = methodList[i];
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !(bytecodeSet = classContext.getBytecodeSet(method)).intersects(prescreenSet)) continue;
            if (DEBUG) {
                System.out.println("FindRefComparison: analyzing " + SignatureConverter.convertMethodSignature((MethodGen)methodGen));
            }
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError(e.toString());
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError(e.toString());
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        boolean sawCallToEquals = false;
        JavaClass jclass = classContext.getJavaClass();
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        this.stringComparison = null;
        this.refComparison = null;
        CFG cfg = classContext.getCFG(method);
        DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
        ExceptionSetFactory exceptionSetFactory = classContext.getExceptionSetFactory(method);
        RefComparisonTypeMerger typeMerger = new RefComparisonTypeMerger((RepositoryLookupFailureCallback)this.bugReporter, exceptionSetFactory);
        RefComparisonTypeFrameModelingVisitor visitor = new RefComparisonTypeFrameModelingVisitor(methodGen.getConstantPool(), (RepositoryLookupFailureCallback)this.bugReporter);
        TypeAnalysis typeAnalysis = new TypeAnalysis(methodGen, cfg, dfs, (TypeMerger)typeMerger, (TypeFrameModelingVisitor)visitor, (RepositoryLookupFailureCallback)this.bugReporter, exceptionSetFactory);
        TypeDataflow typeDataflow = new TypeDataflow(cfg, typeAnalysis);
        typeDataflow.execute();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            Instruction ins = location.getHandle().getInstruction();
            short opcode = ins.getOpcode();
            if (opcode == 165 || opcode == 166) {
                this.checkRefComparison(location, jclass, methodGen, typeDataflow);
                continue;
            }
            if (!invokeInstanceSet.get(opcode)) continue;
            InvokeInstruction inv = (InvokeInstruction)ins;
            String methodName = inv.getMethodName(cpg);
            String methodSig = inv.getSignature(cpg);
            if ((!methodName.equals("equals") || !methodSig.equals("(Ljava/lang/Object;)Z")) && (!methodName.equals("equalIgnoreCases") || !methodSig.equals("(Ljava/lang/String;)Z"))) continue;
            sawCallToEquals = true;
            this.checkEqualsComparison(location, jclass, methodGen, typeDataflow);
        }
        if (this.stringComparison != null) {
            if (sawCallToEquals && this.stringComparison.getPriority() >= 2) {
                this.stringComparison.setPriority(1 + this.stringComparison.getPriority());
            }
            if (this.stringComparison.getPriority() >= 2 && !method.isPublic() && !method.isProtected()) {
                this.stringComparison.setPriority(1 + this.stringComparison.getPriority());
            }
            if (this.stringComparison.getPriority() <= 3) {
                this.bugReporter.reportBug(this.stringComparison);
            }
        }
        if (this.refComparison != null && this.refComparison.getPriority() <= 3) {
            this.bugReporter.reportBug(this.refComparison);
        }
    }

    private void checkRefComparison(Location location, JavaClass jclass, MethodGen methodGen, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        InstructionHandle handle = location.getHandle();
        TypeFrame frame = typeDataflow.getFactAtLocation(location);
        if (frame.getStackDepth() < 2) {
            throw new DataflowAnalysisException("Stack underflow", methodGen, handle);
        }
        int numSlots = frame.getNumSlots();
        Type lhsType = (Type)frame.getValue(numSlots - 1);
        Type rhsType = (Type)frame.getValue(numSlots - 2);
        if (lhsType instanceof ReferenceType && rhsType instanceof ReferenceType) {
            String rhs;
            String lhs = SignatureConverter.convert((String)lhsType.getSignature());
            if (!lhs.equals(rhs = SignatureConverter.convert((String)rhsType.getSignature()))) {
                return;
            }
            if (lhs.equals("java.lang.String") && rhs.equals("java.lang.String")) {
                if (DEBUG) {
                    System.out.println("String/String comparison at " + handle);
                }
                int priority = 2;
                byte type1 = lhsType.getType();
                byte type2 = rhsType.getType();
                if (type1 == 101 && type2 == 101) {
                    priority = 4;
                } else if (type1 == 100 || type2 == 100) {
                    priority = 1;
                } else if (type1 == 101 || type2 == 101) {
                    priority = 3;
                } else if (sawStringIntern) {
                    priority = 3;
                }
                if (priority <= 3) {
                    String sourceFile = jclass.getSourceFileName();
                    BugInstance instance = new BugInstance("ES_COMPARING_STRINGS_WITH_EQ", priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, handle).addClass("java.lang.String").describe("CLASS_REFTYPE");
                    if (REPORT_ALL_REF_COMPARISONS) {
                        this.bugReporter.reportBug(instance);
                    } else if (this.stringComparison == null || priority < this.stringComparison.getPriority()) {
                        this.stringComparison = instance;
                    }
                }
            } else if (suspiciousSet.contains(lhs) && suspiciousSet.contains(rhs)) {
                String sourceFile = jclass.getSourceFileName();
                BugInstance instance = new BugInstance("RC_REF_COMPARISON", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, handle).addClass(lhs).describe("CLASS_REFTYPE");
                if (REPORT_ALL_REF_COMPARISONS) {
                    this.bugReporter.reportBug(instance);
                } else if (this.refComparison == null) {
                    this.refComparison = instance;
                }
            }
        }
    }

    private void checkEqualsComparison(Location location, JavaClass jclass, MethodGen methodGen, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        Type rhsType_;
        InstructionHandle handle = location.getHandle();
        String sourceFile = jclass.getSourceFileName();
        TypeFrame frame = typeDataflow.getFactAtLocation(location);
        if (frame.getStackDepth() < 2) {
            throw new DataflowAnalysisException("Stack underflow", methodGen, handle);
        }
        int numSlots = frame.getNumSlots();
        Type lhsType_ = (Type)frame.getValue(numSlots - 2);
        if (lhsType_.equals(rhsType_ = (Type)frame.getValue(numSlots - 1))) {
            return;
        }
        if (lhsType_.getType() == 17 || lhsType_.getType() == 20 || rhsType_.getType() == 17 || rhsType_.getType() == 20) {
            return;
        }
        if (!(lhsType_ instanceof ReferenceType) || !(rhsType_ instanceof ReferenceType)) {
            if (rhsType_.getType() == 21) {
                this.bugReporter.reportBug(new BugInstance("EC_NULL_ARG", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, location.getHandle()));
            } else if (lhsType_.getType() != 21) {
                this.bugReporter.logError("equals() used to compare non-object type(s) " + lhsType_ + " and " + rhsType_ + " in " + SignatureConverter.convertMethodSignature((MethodGen)methodGen) + " at " + location.getHandle());
            }
            return;
        }
        if (!(lhsType_ instanceof ObjectType) || !(rhsType_ instanceof ObjectType)) {
            return;
        }
        ObjectType lhsType = (ObjectType)lhsType_;
        ObjectType rhsType = (ObjectType)rhsType_;
        int priority = 4;
        String bugType = "EC_UNRELATED_TYPES";
        try {
            if (!Hierarchy.isSubtype((ReferenceType)lhsType, (ReferenceType)rhsType) && !Hierarchy.isSubtype((ReferenceType)rhsType, (ReferenceType)lhsType)) {
                if (lhsType.referencesInterfaceExact() && rhsType.referencesInterfaceExact()) {
                    priority = 2;
                    bugType = "EC_UNRELATED_INTERFACES";
                } else {
                    priority = 1;
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return;
        }
        if (priority <= 3) {
            this.bugReporter.reportBug(new BugInstance(bugType, priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, location.getHandle()).addClass(lhsType.getClassName()).describe("CLASS_REFTYPE").addClass(rhsType.getClassName()).describe("CLASS_REFTYPE"));
        }
    }

    public void report() {
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println("Usage: " + FindRefComparison.class.getName() + " <class file>");
            System.exit(1);
        }
        DataflowTestDriver<TypeFrame, TypeAnalysis> driver = new DataflowTestDriver<TypeFrame, TypeAnalysis>(){

            public Dataflow<TypeFrame, TypeAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                RepositoryLookupFailureCallback lookupFailureCallback = classContext.getLookupFailureCallback();
                MethodGen methodGen = classContext.getMethodGen(method);
                DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
                CFG cfg = classContext.getCFG(method);
                ExceptionSetFactory exceptionSetFactory = classContext.getExceptionSetFactory(method);
                RefComparisonTypeMerger typeMerger = new RefComparisonTypeMerger(lookupFailureCallback, exceptionSetFactory);
                RefComparisonTypeFrameModelingVisitor visitor = new RefComparisonTypeFrameModelingVisitor(methodGen.getConstantPool(), lookupFailureCallback);
                TypeAnalysis analysis = new TypeAnalysis(methodGen, cfg, dfs, (TypeMerger)typeMerger, (TypeFrameModelingVisitor)visitor, lookupFailureCallback, exceptionSetFactory);
                Dataflow dataflow = new Dataflow(cfg, (DataflowAnalysis)analysis);
                dataflow.execute();
                return dataflow;
            }
        };
        driver.execute(argv[0]);
    }

    static {
        suspiciousSet.add("java.lang.Boolean");
        suspiciousSet.add("java.lang.Byte");
        suspiciousSet.add("java.lang.Character");
        suspiciousSet.add("java.lang.Double");
        suspiciousSet.add("java.lang.Float");
        suspiciousSet.add("java.lang.Integer");
        suspiciousSet.add("java.lang.Long");
        suspiciousSet.add("java.lang.Short");
        invokeInstanceSet = new BitSet();
        invokeInstanceSet.set(182);
        invokeInstanceSet.set(185);
        invokeInstanceSet.set(183);
        prescreenSet = new BitSet();
        prescreenSet.or(invokeInstanceSet);
        prescreenSet.set(165);
        prescreenSet.set(166);
        dynamicStringTypeInstance = new DynamicStringType();
        staticStringTypeInstance = new StaticStringType();
    }

    private static class RefComparisonTypeMerger
    extends StandardTypeMerger {
        public RefComparisonTypeMerger(RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
            super(lookupFailureCallback, exceptionSetFactory);
        }

        protected boolean isReferenceType(byte type) {
            return super.isReferenceType(type) || type == 101 || type == 100;
        }

        protected Type mergeReferenceTypes(ReferenceType aRef, ReferenceType bRef) throws DataflowAnalysisException {
            byte aType = aRef.getType();
            byte bType = bRef.getType();
            if (this.isExtendedStringType(aType) || this.isExtendedStringType(bType)) {
                if (aType == bType) {
                    return aRef;
                }
                if (this.isExtendedStringType(aType)) {
                    aRef = Type.STRING;
                }
                if (this.isExtendedStringType(bType)) {
                    bRef = Type.STRING;
                }
            }
            return super.mergeReferenceTypes(aRef, bRef);
        }

        private boolean isExtendedStringType(byte type) {
            return type == 100 || type == 101;
        }
    }

    private static class RefComparisonTypeFrameModelingVisitor
    extends TypeFrameModelingVisitor {
        private RepositoryLookupFailureCallback lookupFailureCallback;

        public RefComparisonTypeFrameModelingVisitor(ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
            super(cpg);
            this.lookupFailureCallback = lookupFailureCallback;
        }

        public void visitINVOKESTATIC(INVOKESTATIC obj) {
            this.consumeStack((Instruction)obj);
            if (this.returnsString((InvokeInstruction)obj)) {
                String className = obj.getClassName(this.getCPG());
                String methodName = obj.getName(this.getCPG());
                if (className.equals("java.lang.String")) {
                    this.pushValue(dynamicStringTypeInstance);
                } else {
                    this.pushReturnType((InvokeInstruction)obj);
                }
            } else {
                this.pushReturnType((InvokeInstruction)obj);
            }
        }

        public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        private boolean returnsString(InvokeInstruction inv) {
            String methodSig = inv.getSignature(this.getCPG());
            return methodSig.endsWith(")Ljava/lang/String;");
        }

        private void handleInstanceMethod(InvokeInstruction obj) {
            this.consumeStack((Instruction)obj);
            if (this.returnsString(obj)) {
                String className = obj.getClassName(this.getCPG());
                String methodName = obj.getName(this.getCPG());
                if (methodName.equals("intern") && className.equals("java.lang.String")) {
                    sawStringIntern = true;
                    this.pushValue(staticStringTypeInstance);
                } else if (methodName.equals("toString") || className.equals("java.lang.String")) {
                    this.pushValue(dynamicStringTypeInstance);
                } else {
                    this.pushReturnType(obj);
                }
            } else {
                this.pushReturnType(obj);
            }
        }

        public void visitLDC(LDC obj) {
            Type type = obj.getType(this.getCPG());
            this.pushValue(this.isString(type) ? staticStringTypeInstance : type);
        }

        public void visitLDC2_W(LDC2_W obj) {
            Type type = obj.getType(this.getCPG());
            this.pushValue(this.isString(type) ? staticStringTypeInstance : type);
        }

        private boolean isString(Type type) {
            return type.getSignature().equals(FindRefComparison.STRING_SIGNATURE);
        }

        public void visitGETSTATIC(GETSTATIC obj) {
            this.handleLoad((FieldInstruction)obj);
        }

        public void visitGETFIELD(GETFIELD obj) {
            this.handleLoad((FieldInstruction)obj);
        }

        private void handleLoad(FieldInstruction obj) {
            this.consumeStack((Instruction)obj);
            Type type = obj.getType(this.getCPG());
            if (type.getSignature().equals(FindRefComparison.STRING_SIGNATURE)) {
                try {
                    String className = obj.getClassName(this.getCPG());
                    String fieldName = obj.getName(this.getCPG());
                    Field field = Hierarchy.findField((String)className, (String)fieldName);
                    if (field != null) {
                        if (field.isFinal()) {
                            this.pushValue(staticStringTypeInstance);
                        } else {
                            this.pushValue(type);
                        }
                        return;
                    }
                }
                catch (ClassNotFoundException ex) {
                    this.lookupFailureCallback.reportMissingClass(ex);
                }
            }
            this.pushValue(type);
        }
    }

    private static class StaticStringType
    extends ObjectType {
        public StaticStringType() {
            super("java.lang.String");
        }

        public byte getType() {
            return 101;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<static string>";
        }
    }

    private static class DynamicStringType
    extends ObjectType {
        public DynamicStringType() {
            super("java.lang.String");
        }

        public byte getType() {
            return 100;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<dynamic string>";
        }
    }
}

