/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InvalidJUnitTest
extends BytecodeScanningDetector
implements Constants2 {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_ALOAD_0 = 1;
    private BugReporter bugReporter;
    private MethodAnnotation setUpAnnotation;
    private MethodAnnotation tearDownAnnotation;
    private String methodName;
    private boolean validClass;
    private boolean validMethod;
    private boolean sawSetUp;
    private boolean sawTearDown;
    private int state;

    public InvalidJUnitTest(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        try {
            this.setUpAnnotation = null;
            this.tearDownAnnotation = null;
            this.validClass = false;
            this.validMethod = false;
            this.sawSetUp = false;
            this.sawTearDown = false;
            JavaClass[] superClasses = obj.getSuperClasses();
            for (int i = 0; i < superClasses.length; ++i) {
                JavaClass sc = superClasses[i];
                if (!sc.getClassName().equals("junit.framework.TestCase")) continue;
                this.validClass = true;
                super.visit(obj);
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void visitAfter(JavaClass obj) {
        if (this.setUpAnnotation != null && !this.sawSetUp) {
            this.bugReporter.reportBug(new BugInstance("IJU_SETUP_NO_SUPER", 2).addClass((PreorderVisitor)this).addMethod(this.setUpAnnotation));
        }
        if (this.tearDownAnnotation != null && !this.sawTearDown) {
            this.bugReporter.reportBug(new BugInstance("IJU_TEARDOWN_NO_SUPER", 2).addClass((PreorderVisitor)this).addMethod(this.tearDownAnnotation));
        }
    }

    public void visit(Method obj) {
        if (!this.validClass) {
            return;
        }
        this.validMethod = false;
        this.methodName = obj.getName();
        if (this.methodName.equals("setUp") || this.methodName.equals("tearDown")) {
            if (this.methodName.equals("setUp")) {
                this.setUpAnnotation = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
            } else if (this.methodName.equals("tearDown")) {
                this.tearDownAnnotation = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
            }
            this.validMethod = true;
            this.state = 0;
            super.visit(obj);
        } else if (this.methodName.equals("suite") && !obj.isStatic()) {
            this.bugReporter.reportBug(new BugInstance("IJU_SUITE_NOT_STATIC", 2).addClass((PreorderVisitor)this).addMethod(MethodAnnotation.fromVisitedMethod((PreorderVisitor)this)));
        }
    }

    public void sawOpcode(int seen) {
        if (!this.validClass || !this.validMethod) {
            return;
        }
        switch (this.state) {
            case 0: {
                if (seen != 42) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 183) {
                    System.out.println(this.getNameConstantOperand());
                }
                if (seen == 183 && this.getNameConstantOperand().equals(this.methodName) && this.getMethodSig().equals("()V")) {
                    if (this.methodName.equals("setUp")) {
                        this.sawSetUp = true;
                    } else if (this.methodName.equals("tearDown")) {
                        this.sawTearDown = true;
                    }
                }
                this.state = 0;
            }
        }
    }
}

