/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ByteCodePatternDetector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DominatorsAnalysis;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.PostDominatorsAnalysis;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.bcp.Binding;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePattern;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePatternMatch;
import edu.umd.cs.findbugs.ba.bcp.FieldVariable;
import edu.umd.cs.findbugs.ba.bcp.IfNull;
import edu.umd.cs.findbugs.ba.bcp.Load;
import edu.umd.cs.findbugs.ba.bcp.PatternElement;
import edu.umd.cs.findbugs.ba.bcp.PatternElementMatch;
import edu.umd.cs.findbugs.ba.bcp.Store;
import edu.umd.cs.findbugs.ba.bcp.Wild;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;

public class LazyInit
extends ByteCodePatternDetector {
    private BugReporter bugReporter;
    private static final boolean DEBUG = Boolean.getBoolean("lazyinit.debug");
    private static ByteCodePattern pattern = new ByteCodePattern();

    public LazyInit(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public ByteCodePattern getPattern() {
        return pattern;
    }

    public boolean prescreen(Method method, ClassContext classContext) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (!(bytecodeSet.get(178) && bytecodeSet.get(179) || bytecodeSet.get(180) && bytecodeSet.get(181))) {
            return false;
        }
        return !method.isSynchronized();
    }

    public void reportMatch(ClassContext classContext, Method method, ByteCodePatternMatch match) throws CFGBuilderException, DataflowAnalysisException {
        JavaClass javaClass = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        try {
            boolean isDefaultAccess;
            BindingSet bindingSet = match.getBindingSet();
            Binding binding = bindingSet.lookup("f");
            FieldVariable field = (FieldVariable)binding.getVariable();
            XField xfield = Hierarchy.findXField((String)field.getClassName(), (String)field.getFieldName(), (String)field.getFieldSig());
            if (xfield == null || (xfield.getAccessFlags() & 0x40) != 0) {
                return;
            }
            if (!xfield.isStatic()) {
                return;
            }
            if (xfield.getFieldName().startsWith("class$") || xfield.getFieldName().startsWith("array$")) {
                if (DEBUG) {
                    System.out.println("Ignoring field " + xfield.getFieldName());
                }
                return;
            }
            if (!xfield.getFieldSignature().startsWith("[")) {
                if (DEBUG) {
                    System.out.println("Ignoring non-reference field " + xfield.getFieldName());
                }
                return;
            }
            PatternElementMatch createBegin = match.getFirstLabeledMatch("createObject");
            PatternElementMatch store = match.getFirstLabeledMatch("end");
            DominatorsAnalysis domAnalysis = classContext.getNonExceptionDominatorsAnalysis(method);
            PostDominatorsAnalysis postDomAnalysis = classContext.getNonExceptionPostDominatorsAnalysis(method);
            BitSet extent = domAnalysis.getAllDominatedBy(createBegin.getBasicBlock());
            extent.and(postDomAnalysis.getAllDominatedBy(store.getBasicBlock()));
            if (DEBUG) {
                System.out.println("Object creation extent: " + extent);
            }
            LockDataflow lockDataflow = classContext.getLockDataflow(method);
            LockSet lockSet = null;
            boolean sawNEW = false;
            boolean sawINVOKE = false;
            Iterator i = cfg.getBlocks(extent).iterator();
            while (i.hasNext()) {
                BasicBlock block = (BasicBlock)i.next();
                BasicBlock.InstructionIterator j = block.instructionIterator();
                while (j.hasNext()) {
                    InstructionHandle handle = (InstructionHandle)j.next();
                    Location location = new Location(handle, block);
                    Instruction ins = handle.getInstruction();
                    if (ins instanceof NEW) {
                        sawNEW = true;
                    } else if (ins instanceof InvokeInstruction) {
                        sawINVOKE = true;
                    }
                    LockSet insLockSet = lockDataflow.getFactAtLocation(location);
                    if (lockSet == null) {
                        lockSet = new LockSet();
                        lockSet.copyFrom(insLockSet);
                        continue;
                    }
                    lockSet.intersectWith(insLockSet);
                }
            }
            if (!sawNEW && !sawINVOKE) {
                return;
            }
            if (lockSet == null) {
                throw new IllegalStateException();
            }
            if (!lockSet.isEmpty()) {
                return;
            }
            int priority = 3;
            boolean bl = isDefaultAccess = (method.getAccessFlags() & 7) == 0;
            if (method.isPublic()) {
                priority = 2;
            } else if (method.isProtected() || isDefaultAccess) {
                priority = 2;
            }
            InstructionHandle start = match.getLabeledInstruction("start");
            InstructionHandle end = match.getLabeledInstruction("end");
            String sourceFile = javaClass.getSourceFileName();
            this.bugReporter.reportBug(new BugInstance("LI_LAZY_INIT_STATIC", priority).addClassAndMethod(methodGen, sourceFile).addField(xfield).describe("FIELD_ON").addSourceLine(methodGen, sourceFile, start, end));
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return;
        }
    }

    static {
        pattern.add(new Load("f", "val").label("start")).add((PatternElement)new IfNull("val")).add(new Wild(1, 1).label("createObject")).add(new Store("f", pattern.dummyVariable()).label("end").dominatedBy("createObject"));
    }
}

