/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Method;

public class ReadReturnShouldBeChecked
extends BytecodeScanningDetector
implements Constants2 {
    boolean sawRead = false;
    boolean sawSkip = false;
    int sawAvailable = 0;
    boolean isBufferedInputStream = false;
    private BugReporter bugReporter;
    private int readPC;
    private int skipPC;
    private String lastCallClass = null;
    private String lastCallMethod = null;
    private String lastCallSig = null;

    public ReadReturnShouldBeChecked(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        this.sawAvailable = 0;
        this.sawRead = false;
        this.sawSkip = false;
    }

    public void sawOpcode(int seen) {
        if (seen == 182 || seen == 185) {
            this.lastCallClass = this.getDottedClassConstantOperand();
            this.lastCallMethod = this.getNameConstantOperand();
            this.lastCallSig = this.getDottedSigConstantOperand();
        }
        if ((seen == 182 || seen == 185) && this.getNameConstantOperand().equals("available") && this.getSigConstantOperand().equals("()I") || (seen == 182 || seen == 185) && this.getNameConstantOperand().startsWith("get") && this.getNameConstantOperand().endsWith("Length") && this.getSigConstantOperand().equals("()I") || (seen == 182 || seen == 185) && this.getClassConstantOperand().equals("java/io/File") && this.getNameConstantOperand().equals("length") && this.getSigConstantOperand().equals("()J")) {
            this.sawAvailable = 70;
            return;
        }
        --this.sawAvailable;
        if ((seen == 182 || seen == 185) && !this.getClassConstantOperand().equals("java/io/ByteArrayInputStream") && this.getNameConstantOperand().equals("read") && (this.getSigConstantOperand().startsWith("([B") || this.getSigConstantOperand().startsWith("([C")) && this.sawAvailable <= 0) {
            boolean b = false;
            try {
                b = Repository.instanceOf((String)this.getClassConstantOperand(), (String)"java/io/ByteArrayInputStream");
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (!b) {
                this.sawRead = true;
                this.readPC = this.getPC();
                return;
            }
        } else if ((seen == 182 || seen == 185) && !this.getClassConstantOperand().equals("java/io/ByteArrayInputStream") && this.getNameConstantOperand().equals("skip")) {
            boolean bais = false;
            boolean bis = false;
            try {
                bais = Repository.instanceOf((String)this.getClassConstantOperand(), (String)"java/io/ByteArrayInputStream");
                bis = Repository.instanceOf((String)this.getClassConstantOperand(), (String)"java/io/BufferedInputStream");
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (!bais && (this.sawAvailable <= 0 || bis)) {
                this.isBufferedInputStream = bis;
                this.sawSkip = true;
                this.skipPC = this.getPC();
                return;
            }
        }
        if (seen == 87 || seen == 88) {
            if (this.sawRead) {
                this.bugReporter.reportBug(new BugInstance("RR_NOT_CHECKED", 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod(this.lastCallClass, this.lastCallMethod, this.lastCallSig).addSourceLine((PreorderVisitor)this, this.readPC));
            } else if (this.sawSkip) {
                boolean isBufferedInputStream = false;
                try {
                    isBufferedInputStream = Repository.instanceOf((String)this.lastCallClass, (String)"java/io/BufferedInputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                this.bugReporter.reportBug(new BugInstance("SR_NOT_CHECKED", isBufferedInputStream ? 1 : 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod(this.lastCallClass, this.lastCallMethod, this.lastCallSig).addSourceLine((PreorderVisitor)this, this.skipPC));
            }
        }
        this.sawRead = false;
        this.sawSkip = false;
    }
}

