/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Visitor;

public class SerializableIdiom
extends PreorderVisitor
implements Detector,
Constants2 {
    boolean sawSerialVersionUID;
    boolean isSerializable;
    boolean implementsSerializableDirectly;
    boolean isExternalizable;
    boolean isGUIClass;
    boolean foundSynthetic;
    boolean foundSynchronizedMethods;
    boolean writeObjectIsSynchronized;
    private BugReporter bugReporter;
    private AnalysisContext analysisContext;
    boolean isAbstract;
    private List<BugInstance> fieldWarningList = new LinkedList<BugInstance>();
    private boolean sawReadExternal;
    private boolean sawWriteExternal;
    private boolean sawReadObject;
    private boolean sawWriteObject;
    private boolean superClassImplementsSerializable;
    private boolean hasPublicVoidConstructor;
    private boolean superClassHasVoidConstructor;
    private boolean directlyImplementsExternalizable;

    public SerializableIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void setAnalysisContext(AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
        this.flush();
    }

    private void flush() {
        if (!(this.isAbstract || this.sawReadExternal && this.sawWriteExternal || this.sawReadObject && this.sawWriteObject)) {
            Iterator<BugInstance> i = this.fieldWarningList.iterator();
            while (i.hasNext()) {
                this.bugReporter.reportBug(i.next());
            }
        }
        this.fieldWarningList.clear();
    }

    public void report() {
    }

    public void visit(JavaClass obj) {
        int flags = obj.getAccessFlags();
        this.isAbstract = (flags & 0x400) != 0 || (flags & 0x200) != 0;
        this.sawSerialVersionUID = false;
        this.implementsSerializableDirectly = false;
        this.isSerializable = false;
        this.isExternalizable = false;
        this.directlyImplementsExternalizable = false;
        this.isGUIClass = false;
        String[] interface_names = obj.getInterfaceNames();
        for (int i = 0; i < interface_names.length; ++i) {
            if (interface_names[i].equals("java.io.Externalizable")) {
                this.directlyImplementsExternalizable = true;
                this.isExternalizable = true;
                continue;
            }
            if (!interface_names[i].equals("java.io.Serializable")) continue;
            this.implementsSerializableDirectly = true;
            this.isSerializable = true;
            break;
        }
        if (!this.isSerializable) {
            try {
                if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Externalizable")) {
                    this.isExternalizable = true;
                }
                if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Serializable")) {
                    this.isSerializable = true;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        this.hasPublicVoidConstructor = false;
        this.superClassHasVoidConstructor = true;
        this.superClassImplementsSerializable = this.isSerializable && !this.implementsSerializableDirectly;
        try {
            JavaClass superClass = obj.getSuperClass();
            if (superClass != null) {
                Method[] superClassMethods = superClass.getMethods();
                this.superClassImplementsSerializable = Repository.instanceOf((JavaClass)superClass, (String)"java.io.Serializable");
                this.superClassHasVoidConstructor = false;
                for (int i = 0; i < superClassMethods.length; ++i) {
                    Method m = superClassMethods[i];
                    if (!m.getName().equals("<init>") || !m.getSignature().equals("()V") || m.isPrivate()) continue;
                    this.superClassHasVoidConstructor = true;
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        try {
            this.isGUIClass = Repository.instanceOf((JavaClass)obj, (String)"java.awt.Component");
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        this.foundSynthetic = false;
        this.foundSynchronizedMethods = false;
        this.writeObjectIsSynchronized = false;
        this.sawWriteObject = false;
        this.sawReadObject = false;
        this.sawWriteExternal = false;
        this.sawReadExternal = false;
    }

    public void visitAfter(JavaClass obj) {
        int priority;
        if (this.isSerializable && !this.isExternalizable && !this.superClassHasVoidConstructor && !this.superClassImplementsSerializable) {
            this.bugReporter.reportBug(new BugInstance("SE_NO_SUITABLE_CONSTRUCTOR", this.implementsSerializableDirectly || this.sawSerialVersionUID ? 1 : 2).addClass(this.getThisClass().getClassName()));
        }
        int n = priority = this.isGUIClass ? 3 : 2;
        if (obj.getClassName().endsWith("_Stub")) {
            ++priority;
        }
        if (this.isExternalizable && !this.hasPublicVoidConstructor && !this.isAbstract) {
            this.bugReporter.reportBug(new BugInstance("SE_NO_SUITABLE_CONSTRUCTOR_FOR_EXTERNALIZATION", this.directlyImplementsExternalizable ? 1 : 2).addClass(this.getThisClass().getClassName()));
        }
        if (this.foundSynthetic && !this.isExternalizable && !this.isGUIClass && this.isSerializable && !this.isAbstract && !this.sawSerialVersionUID) {
            this.bugReporter.reportBug(new BugInstance("SE_NO_SERIALVERSIONID", priority).addClass((PreorderVisitor)this));
        }
        if (this.writeObjectIsSynchronized && !this.foundSynchronizedMethods) {
            this.bugReporter.reportBug(new BugInstance("WS_WRITEOBJECT_SYNC", 3).addClass((PreorderVisitor)this));
        }
    }

    public void visit(Method obj) {
        boolean isSynchronized;
        int accessFlags = obj.getAccessFlags();
        boolean bl = isSynchronized = (accessFlags & 0x20) != 0;
        if (this.getMethodName().equals("<init>") && this.getMethodSig().equals("()V") && (accessFlags & 1) != 0) {
            this.hasPublicVoidConstructor = true;
        }
        if (!this.getMethodName().equals("<init>") && this.isSynthetic((FieldOrMethod)obj)) {
            this.foundSynthetic = true;
        }
        if (this.getMethodName().equals("readExternal") && this.getMethodSig().equals("(Ljava/io/ObjectInput;)V")) {
            this.sawReadExternal = true;
        } else if (this.getMethodName().equals("writeExternal") && this.getMethodSig().equals("(Ljava/io/Objectoutput;)V")) {
            this.sawWriteExternal = true;
        } else if (this.getMethodName().equals("readObject") && this.getMethodSig().equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
            this.sawReadObject = true;
        } else if (this.getMethodName().equals("writeObject") && this.getMethodSig().equals("(Ljava/io/ObjectOutputStream;)V") && this.isSerializable) {
            this.sawReadObject = true;
        }
        if (!isSynchronized) {
            return;
        }
        if (this.getMethodName().equals("readObject") && this.getMethodSig().equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
            this.bugReporter.reportBug(new BugInstance("RS_READOBJECT_SYNC", 2).addClass((PreorderVisitor)this));
        } else if (this.getMethodName().equals("writeObject") && this.getMethodSig().equals("(Ljava/io/ObjectOutputStream;)V") && this.isSerializable) {
            this.writeObjectIsSynchronized = true;
        } else {
            this.foundSynchronizedMethods = true;
        }
    }

    boolean isSynthetic(FieldOrMethod obj) {
        Attribute[] a = obj.getAttributes();
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    public void visit(Field obj) {
        int flags = obj.getAccessFlags();
        if (this.getClassName().indexOf("ObjectStreamClass") == -1 && this.isSerializable && !this.isExternalizable && this.getFieldSig().indexOf("L") >= 0 && !obj.isTransient() && !obj.isStatic()) {
            try {
                String fieldTypeClassName = this.getFieldSig().substring(this.getFieldSig().indexOf("L") + 1, this.getFieldSig().length() - 1).replace('/', '.');
                JavaClass fieldTypeClass = Repository.lookupClass((String)fieldTypeClassName);
                if (!(fieldTypeClassName.equals("java.lang.Object") || Repository.instanceOf((JavaClass)fieldTypeClass, (String)"java.io.Serializable") || Repository.instanceOf((JavaClass)fieldTypeClass, (String)"java.io.Externalizable"))) {
                    int priority = 2;
                    if (this.implementsSerializableDirectly || this.sawSerialVersionUID) {
                        --priority;
                    }
                    if (this.isGUIClass) {
                        ++priority;
                    }
                    if (fieldTypeClass.isInterface() || fieldTypeClass.isAbstract()) {
                        priority = Math.max(3, priority + 1);
                        if (Repository.instanceOf((JavaClass)fieldTypeClass, (String)"java.util.Collection")) {
                            return;
                        }
                    }
                    this.fieldWarningList.add(new BugInstance("SE_BAD_FIELD", priority).addClass(this.getThisClass().getClassName()).addField(this.getDottedClassName(), obj.getName(), this.getFieldSig(), false));
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        if (!this.getFieldName().startsWith("this") && this.isSynthetic((FieldOrMethod)obj)) {
            this.foundSynthetic = true;
        }
        if (!this.getFieldName().equals("serialVersionUID")) {
            return;
        }
        int mask = 24;
        if (!this.getFieldSig().equals("I") && !this.getFieldSig().equals("J")) {
            return;
        }
        if ((flags & mask) == mask && this.getFieldSig().equals("I")) {
            this.bugReporter.reportBug(new BugInstance("SE_NONLONG_SERIALVERSIONID", 3).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            this.sawSerialVersionUID = true;
            return;
        }
        if ((flags & 8) == 0) {
            this.bugReporter.reportBug(new BugInstance("SE_NONSTATIC_SERIALVERSIONID", 2).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            return;
        }
        if ((flags & 0x10) == 0) {
            this.bugReporter.reportBug(new BugInstance("SE_NONFINAL_SERIALVERSIONID", 2).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            return;
        }
        this.sawSerialVersionUID = true;
    }
}

