/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class BadAppletConstructor
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    private BugReporter bugReporter;
    private JavaClass appletClass;
    private boolean inConstructor;

    public BadAppletConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.appletClass = Repository.lookupClass((String)"java.applet.Applet");
        }
        catch (ClassNotFoundException cnfe) {
            bugReporter.reportMissingClass(cnfe);
            this.appletClass = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitClassContext(ClassContext classContext) {
        if (this.appletClass == null) {
            return;
        }
        JavaClass cls = classContext.getJavaClass();
        try {
            if (cls.instanceOf(this.appletClass)) {
                cls.accept((Visitor)this);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void visit(Method obj) {
        this.inConstructor = obj.getName().equals("<init>");
    }

    public void visit(Code obj) {
        if (this.inConstructor) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 182) {
            String method = this.getNameConstantOperand();
            String signature = this.getSigConstantOperand();
            if ((method.equals("getDocumentBase") || method.equals("getCodeBase")) && signature.equals("()Ljava/net/URL;") || method.equals("getAppletContext") && signature.equals("()Ljava/applet/AppletContext;") || method.equals("getParameter") && signature.equals("(Ljava/lang/String;)Ljava/lang/String;")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "BAC_BAD_APPLET_CONSTRUCTOR", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
            }
        }
    }
}

