/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class BadUseOfReturnValue
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    BugReporter bugReporter;
    boolean readLineOnTOS = false;
    boolean stringIndexOfOnTOS = false;

    public BadUseOfReturnValue(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Code obj) {
        this.stringIndexOfOnTOS = false;
        this.readLineOnTOS = false;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && this.getNameConstantOperand().equals("indexOf") && this.getClassConstantOperand().equals("java/lang/String") && this.getSigConstantOperand().equals("(Ljava/lang/String;)I")) {
            this.stringIndexOfOnTOS = true;
        } else if (this.stringIndexOfOnTOS) {
            if (seen == 158 || seen == 157) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "RV_CHECK_FOR_POSITIVE_INDEXOF", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
            }
            this.stringIndexOfOnTOS = false;
        }
        if (seen == 182 && this.getNameConstantOperand().equals("readLine") && this.getSigConstantOperand().equals("()Ljava/lang/String;")) {
            this.readLineOnTOS = true;
        } else if (this.readLineOnTOS) {
            if (seen == 198 || seen == 199) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "RV_DONT_JUST_NULL_CHECK_READLINE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
            }
            this.readLineOnTOS = false;
        }
    }
}

