/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodFactory;
import edu.umd.cs.findbugs.ba.npe.MayReturnNullPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.NonNullParamProperty;
import edu.umd.cs.findbugs.ba.npe.NonNullParamPropertyDatabase;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildNonNullAnnotationDatabase
extends AnnotationVisitor {
    private static final boolean DEBUG = Boolean.getBoolean("fnd.debug.annotation");
    private static final String NONNULL_ANNOTATION_CLASS = "edu/umd/cs/findbugs/annotations/NonNull";
    private static final String POSSIBLY_NULL_ANNOTATION_CLASS = "edu/umd/cs/findbugs/annotations/PossiblyNull";
    private NonNullParamPropertyDatabase nonNullDatabase;
    private NonNullParamPropertyDatabase possiblyNullDatabase;
    private MayReturnNullPropertyDatabase nullReturnValueDatabase;
    private HashSet<XMethod> createdMethodParameterPropertySet;

    public BuildNonNullAnnotationDatabase() {
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        this.nonNullDatabase = BuildNonNullAnnotationDatabase.createIfNeeded(analysisContext.getNonNullParamDatabase());
        analysisContext.setNonNullParamDatabase(this.nonNullDatabase);
        this.possiblyNullDatabase = BuildNonNullAnnotationDatabase.createIfNeeded(analysisContext.getPossiblyNullParamDatabase());
        analysisContext.setPossiblyNullParamDatabase(this.possiblyNullDatabase);
        this.nullReturnValueDatabase = BuildNonNullAnnotationDatabase.createIfNeeded(analysisContext.getNullReturnValueAnnotationDatabase());
        analysisContext.setNullReturnValueAnnotationDatabase(this.nullReturnValueDatabase);
        this.createdMethodParameterPropertySet = new HashSet();
    }

    private static NonNullParamPropertyDatabase createIfNeeded(NonNullParamPropertyDatabase database) {
        return database != null ? database : new NonNullParamPropertyDatabase();
    }

    private static MayReturnNullPropertyDatabase createIfNeeded(MayReturnNullPropertyDatabase database) {
        return database != null ? database : new MayReturnNullPropertyDatabase();
    }

    protected NonNullParamPropertyDatabase getNonNullDatabase() {
        return this.nonNullDatabase;
    }

    protected NonNullParamPropertyDatabase getPossiblyNullDatabase() {
        return this.possiblyNullDatabase;
    }

    protected MayReturnNullPropertyDatabase getNullReturnValueDatabase() {
        return this.nullReturnValueDatabase;
    }

    private static boolean isNonNullAnnotation(String annotationClass) {
        return annotationClass.equals(NONNULL_ANNOTATION_CLASS) || annotationClass.equals(POSSIBLY_NULL_ANNOTATION_CLASS);
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        if (!this.visitingMethod() || !BuildNonNullAnnotationDatabase.isNonNullAnnotation(annotationClass)) {
            return;
        }
        Boolean property = annotationClass.equals(NONNULL_ANNOTATION_CLASS) ? Boolean.FALSE : Boolean.TRUE;
        XMethod xmethod = XMethodFactory.createXMethod((PreorderVisitor)this);
        this.nullReturnValueDatabase.setProperty((Object)xmethod, (Object)property);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Return value @").append(annotationClass.substring(annotationClass.lastIndexOf(47) + 1)).append(" in ").append(xmethod).toString());
        }
    }

    public void visitParameterAnnotation(int p, String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        NonNullParamPropertyDatabase database;
        NonNullParamProperty property;
        if (!BuildNonNullAnnotationDatabase.isNonNullAnnotation(annotationClass)) {
            return;
        }
        XMethod xmethod = XMethodFactory.createXMethod((PreorderVisitor)this);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Parameter ").append(p).append(" @").append(annotationClass.substring(annotationClass.lastIndexOf(47) + 1)).append(" in ").append(xmethod.toString()).toString());
        }
        if (!this.createdMethodParameterPropertySet.contains(xmethod)) {
            this.nonNullDatabase.removeProperty((Object)xmethod);
            this.possiblyNullDatabase.removeProperty((Object)xmethod);
            this.createdMethodParameterPropertySet.add(xmethod);
        }
        if ((property = (NonNullParamProperty)(database = annotationClass.equals(NONNULL_ANNOTATION_CLASS) ? this.nonNullDatabase : this.possiblyNullDatabase).getProperty((Object)xmethod)) == null) {
            property = new NonNullParamProperty();
            database.setProperty((Object)xmethod, (Object)property);
        }
        property.setNonNull(p, true);
    }
}

