/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodFactory;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.MayReturnNullPropertyDatabase;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ReturnInstruction;

public class BuildNullReturnValueDatabase {
    private static final boolean DEBUG = Boolean.getBoolean("fnd.debug.nullreturn");
    private MayReturnNullPropertyDatabase database;

    public MayReturnNullPropertyDatabase getDatabase() {
        return this.database;
    }

    public void visitClassContext(ClassContext classContext) {
        if (this.database == null) {
            this.database = AnalysisContext.currentAnalysisContext().getMayReturnNullDatabase();
            if (this.database == null) {
                this.database = new MayReturnNullPropertyDatabase();
                AnalysisContext.currentAnalysisContext().setMayReturnNullDatabase(this.database);
            }
        }
        Method[] methodList = classContext.getJavaClass().getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            String methodSig = method.getSignature();
            if (methodSig.indexOf(")L") < 0 && methodSig.indexOf(")[") < 0 || classContext.getMethodGen(method) == null) continue;
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        if (DEBUG) {
            System.out.println("Checking for null return value: " + SignatureConverter.convertMethodSignature((JavaClass)classContext.getJavaClass(), (Method)method));
        }
        try {
            CFG cfg = classContext.getCFG(method);
            IsNullValueDataflow invDataflow = classContext.getIsNullValueDataflow(method);
            BasicBlock exit = cfg.getExit();
            Iterator i = cfg.incomingEdgeIterator((AbstractVertex)exit);
            while (i.hasNext()) {
                IsNullValue tos;
                IsNullValueFrame frame;
                BasicBlock source;
                InstructionHandle last;
                Instruction ins;
                Edge edge = (Edge)i.next();
                if (edge.getType() != 7 || !((ins = (last = (source = (BasicBlock)edge.getSource()).getLastInstruction()).getInstruction()) instanceof ReturnInstruction) || !(frame = invDataflow.getFactAtLocation(new Location(last, source))).isValid() || !(tos = (IsNullValue)frame.getTopValue()).mightBeNull()) continue;
                XMethod xmethod = XMethodFactory.createXMethod((JavaClass)classContext.getJavaClass(), (Method)method);
                this.database.setProperty((Object)xmethod, (Object)Boolean.TRUE);
                if (DEBUG) {
                    System.out.println("Null return: " + xmethod + "=true");
                }
                return;
            }
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + method + " for null value return training", (Throwable)e);
        }
        catch (CFGBuilderException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + method + " for null value return training", (Throwable)e);
        }
    }
}

