/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Visitor;

public class DontCatchIllegalMonitorStateException
extends PreorderVisitor
implements Detector,
Constants2,
StatelessDetector {
    private static final boolean DEBUG = Boolean.getBoolean("dcimse.debug");
    BugReporter bugReporter;
    Set<String> msgs = null;

    public DontCatchIllegalMonitorStateException(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (DEBUG) {
            this.msgs = new HashSet<String>();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(ExceptionTable obj) {
        if (DEBUG) {
            String[] names = obj.getExceptionNames();
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals("java.lang.Exception") && !names[i].equals("java.lang.Throwable")) continue;
                System.out.println(names[i] + " thrown by " + this.getFullyQualifiedMethodName());
            }
        }
    }

    public void visit(CodeException obj) {
        String msg;
        int type = obj.getCatchType();
        if (type == 0) {
            return;
        }
        String name = this.getConstantPool().constantToString(this.getConstantPool().getConstant(type));
        if (DEBUG && this.msgs.add(msg = "Catching " + name + " in " + this.getFullyQualifiedMethodName())) {
            System.out.println(msg);
        }
        if (name.equals("java.lang.IllegalMonitorStateException")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "IMSE_DONT_CATCH_IMSE", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((PreorderVisitor)this, obj.getHandlerPC()));
        }
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }
}

