/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class DumbMethodInvocations
implements Detector {
    private BugReporter bugReporter;

    public DumbMethodInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList = classContext.getJavaClass().getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        ConstantDataflow constantDataflow = classContext.getConstantDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            int v;
            Constant operandValue;
            Location location = (Location)i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction iins = (InvokeInstruction)ins;
            ConstantFrame frame = constantDataflow.getFactAtLocation(location);
            if (!frame.isValid() || !iins.getName(cpg).equals("substring") || !iins.getSignature(cpg).equals("(I)Ljava/lang/String;") || !iins.getClassName(cpg).equals("java.lang.String") || !(operandValue = (Constant)frame.getTopValue()).isConstantInteger() || (v = operandValue.getConstantInt()) != 0) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_USELESS_SUBSTRING", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(SourceLineAnnotation.fromVisitedInstruction((MethodGen)methodGen, (String)sourceFile, (InstructionHandle)location.getHandle())));
        }
    }

    public void report() {
    }
}

