/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.util.ByteSequence;

public class DuplicateBranches
extends PreorderVisitor
implements Detector,
StatelessDetector,
Constants2 {
    private ClassContext classContext;
    private BugReporter bugReporter;

    public DuplicateBranches(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visitMethod(Method method) {
        try {
            if (method.getCode() == null) {
                return;
            }
            CFG cfg = this.classContext.getCFG(method);
            Iterator bbi = cfg.blockIterator();
            while (bbi.hasNext()) {
                BasicBlock bb = (BasicBlock)bbi.next();
                int numOutgoing = cfg.getNumOutgoingEdges((AbstractVertex)bb);
                if (numOutgoing == 2) {
                    this.findIfElseDuplicates(cfg, method, bb);
                    continue;
                }
                if (numOutgoing <= 2) continue;
                this.findSwitchDuplicates(cfg, method, bb);
            }
        }
        catch (Exception e) {
            this.bugReporter.logError("Failure examining basic blocks in Duplicate Branches detector", (Throwable)e);
        }
    }

    private void findIfElseDuplicates(CFG cfg, Method method, BasicBlock bb) {
        byte[] elseBytes;
        BasicBlock thenBB = null;
        BasicBlock elseBB = null;
        Iterator iei = cfg.outgoingEdgeIterator((AbstractVertex)bb);
        while (iei.hasNext()) {
            Edge e = (Edge)iei.next();
            if (e.getType() == 1) {
                elseBB = (BasicBlock)e.getTarget();
                continue;
            }
            if (e.getType() != 0) continue;
            thenBB = (BasicBlock)e.getTarget();
        }
        if (thenBB == null || elseBB == null || thenBB.getFirstInstruction() == null || elseBB.getFirstInstruction() == null) {
            return;
        }
        int thenStartPos = thenBB.getFirstInstruction().getPosition();
        int elseStartPos = elseBB.getFirstInstruction().getPosition();
        BasicBlock thenFinishBlock = this.findThenFinish(cfg, thenBB, elseStartPos);
        if (thenFinishBlock == null) {
            return;
        }
        Instruction lastFinishIns = thenFinishBlock.getLastInstruction().getInstruction();
        if (!(lastFinishIns instanceof GotoInstruction)) {
            return;
        }
        int thenFinishPos = thenFinishBlock.getLastInstruction().getPosition();
        int elseFinishPos = ((GotoInstruction)lastFinishIns).getTarget().getPosition();
        if (thenFinishPos >= elseStartPos) {
            return;
        }
        if (thenFinishPos - thenStartPos != elseFinishPos - elseStartPos) {
            return;
        }
        byte[] thenBytes = this.getCodeBytes(method, thenStartPos, thenFinishPos);
        if (!Arrays.equals(thenBytes, elseBytes = this.getCodeBytes(method, elseStartPos, elseFinishPos))) {
            return;
        }
        this.bugReporter.reportBug(new BugInstance((Detector)this, "DB_DUPLICATE_BRANCHES", 3).addClass(this.classContext.getJavaClass()).addMethod(this.classContext.getJavaClass().getClassName(), method.getName(), method.getSignature()).addSourceLineRange((PreorderVisitor)this, thenBB.getFirstInstruction().getPosition(), thenBB.getLastInstruction().getPosition()).addSourceLineRange((PreorderVisitor)this, elseBB.getFirstInstruction().getPosition(), elseBB.getLastInstruction().getPosition()));
    }

    private void findSwitchDuplicates(CFG cfg, Method method, BasicBlock bb) {
        Iterator iei = cfg.outgoingEdgeIterator((AbstractVertex)bb);
        int[] switchPos = new int[cfg.getNumOutgoingEdges((AbstractVertex)bb) + 1];
        int idx = 0;
        while (iei.hasNext()) {
            InstructionHandle firstIns;
            BasicBlock target;
            Edge e = (Edge)iei.next();
            if (2 == e.getType()) {
                target = (BasicBlock)e.getTarget();
                firstIns = target.getFirstInstruction();
                if (firstIns == null) {
                    return;
                }
                switchPos[idx++] = firstIns.getPosition();
                continue;
            }
            if (3 == e.getType()) {
                target = (BasicBlock)e.getTarget();
                firstIns = target.getFirstInstruction();
                if (firstIns == null) {
                    return;
                }
                switchPos[idx++] = firstIns.getPosition();
                continue;
            }
            return;
        }
        Arrays.sort(switchPos);
        if (switchPos.length < 2) {
            return;
        }
        for (int i = 0; i < switchPos.length - 2; ++i) {
            int s1Length = switchPos[i + 1] - switchPos[i];
            if (s1Length == 0) continue;
            byte[] s1Bytes = null;
            for (int j = i + 1; j < switchPos.length - 1; ++j) {
                byte[] s2Bytes;
                int s2Length = switchPos[j + 1] - switchPos[j];
                if (s2Length == 0 || s1Length != s2Length) continue;
                if (s1Bytes == null) {
                    s1Bytes = this.getCodeBytes(method, switchPos[i], switchPos[i + 1]);
                }
                if (!Arrays.equals(s1Bytes, s2Bytes = this.getCodeBytes(method, switchPos[j], switchPos[j + 1]))) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DB_DUPLICATE_BRANCHES", 3).addClass(this.classContext.getJavaClass()).addMethod(this.classContext.getJavaClass().getClassName(), method.getName(), method.getSignature()).addSourceLineRange((PreorderVisitor)this, switchPos[i], switchPos[i + 1] - 1).addSourceLineRange((PreorderVisitor)this, switchPos[j], switchPos[j + 1] - 1));
                j = switchPos.length;
            }
        }
    }

    private byte[] getCodeBytes(Method m, int start, int end) {
        byte[] code = m.getCode().getCode();
        byte[] bytes = new byte[end - start];
        System.arraycopy(code, start, bytes, 0, end - start);
        try {
            int pos;
            ByteSequence sequence = new ByteSequence(code);
            while (sequence.available() > 0 && sequence.getIndex() < start) {
                Instruction.readInstruction((ByteSequence)sequence);
            }
            while (sequence.available() > 0 && (pos = sequence.getIndex()) < end) {
                BranchInstruction bi;
                int offset;
                Instruction ins = Instruction.readInstruction((ByteSequence)sequence);
                if (!(ins instanceof BranchInstruction) || ins instanceof TABLESWITCH || ins instanceof LOOKUPSWITCH || (offset = (bi = (BranchInstruction)ins).getIndex()) + pos < end) continue;
                bytes[pos + bi.getLength() - 1 - start] = 0;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return bytes;
    }

    private BasicBlock findThenFinish(CFG cfg, BasicBlock thenBB, int elsePos) {
        int targetPos;
        Edge e;
        Iterator ie = cfg.outgoingEdgeIterator((AbstractVertex)thenBB);
        while (ie.hasNext()) {
            InstructionHandle firstInsH;
            e = (Edge)ie.next();
            if (e.getType() != 6 || (firstInsH = ((BasicBlock)e.getTarget()).getFirstInstruction()) == null || (targetPos = firstInsH.getPosition()) <= elsePos) continue;
            return (BasicBlock)e.getSource();
        }
        ie = cfg.outgoingEdgeIterator((AbstractVertex)thenBB);
        while (ie.hasNext()) {
            e = (Edge)ie.next();
            if (e.getType() != 0) continue;
            BasicBlock target = (BasicBlock)e.getTarget();
            if (target.getFirstInstruction() == null) {
                return this.findThenFinish(cfg, target, elsePos);
            }
            targetPos = target.getFirstInstruction().getPosition();
            if (targetPos >= elsePos) continue;
            return this.findThenFinish(cfg, target, elsePos);
        }
        return null;
    }

    public void report() {
    }
}

