/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class EqStringTest
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    boolean constantOnTOS = false;
    boolean callToInternSeen = false;
    private BugReporter bugReporter;

    public EqStringTest(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.constantOnTOS = false;
        this.callToInternSeen = false;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 18: {
                this.constantOnTOS = true;
                return;
            }
            case 182: {
                if (!this.getRefConstantOperand().equals("java.lang.String.intern : ()Ljava.lang.String;") && !this.getRefConstantOperand().equals("java.lang.String.equals : (Ljava.lang.Object;)Z")) break;
                this.callToInternSeen = true;
                break;
            }
            case 165: 
            case 166: {
                if (!this.constantOnTOS || this.callToInternSeen) break;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "ES_COMPARING_STRINGS_WITH_EQ", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((PreorderVisitor)this, this.getPC()));
                break;
            }
        }
        this.constantOnTOS = false;
    }
}

