/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindBadCast
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    private HashSet<String> castTo = new HashSet();
    BugReporter bugReporter;
    static final boolean DEBUG = false;
    private Set<String> concreteCollectionClasses = new HashSet<String>();
    private Set<String> abstractCollectionClasses = new HashSet<String>();
    private int parameters;
    OpcodeStack stack = new OpcodeStack();

    public FindBadCast(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.abstractCollectionClasses.add("java/util/Collection");
        this.abstractCollectionClasses.add("java/util/List");
        this.abstractCollectionClasses.add("java/util/Set");
        this.abstractCollectionClasses.add("java/util/Map");
        this.concreteCollectionClasses.add("java/util/LinkedHashMap");
        this.concreteCollectionClasses.add("java/util/LinkedHashSet");
        this.concreteCollectionClasses.add("java/util/HashMap");
        this.concreteCollectionClasses.add("java/util/HashSet");
        this.concreteCollectionClasses.add("java/util/TreeMap");
        this.concreteCollectionClasses.add("java/util/TreeSet");
        this.concreteCollectionClasses.add("java/util/ArrayList");
        this.concreteCollectionClasses.add("java/util/LinkedList");
        this.concreteCollectionClasses.add("java/util/Hashtable");
        this.concreteCollectionClasses.add("java/util/Vector");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
    }

    public void visit(Code obj) {
        this.parameters = this.stack.resetForMethodEntry((PreorderVisitor)this);
        this.castTo.clear();
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (this.stack.getStackDepth() > 0) {
            if (seen == 192 || seen == 193) {
                OpcodeStack.Item it = this.stack.getStackItem(0);
                String signature = it.getSignature();
                if (signature.length() > 0 && signature.charAt(0) == 'L') {
                    signature = signature.substring(1, signature.length() - 1);
                }
                String signatureDot = signature.replace('/', '.');
                String to = this.getClassConstantOperand();
                if (to.length() > 0 && to.charAt(0) == 'L') {
                    to = to.substring(1, to.length() - 1);
                }
                String toDot = to.replace('/', '.');
                if (signature.length() > 0 && !signature.equals("java/lang/Object") && !signature.equals(to)) {
                    try {
                        JavaClass toClass = Repository.lookupClass((String)toDot);
                        JavaClass signatureClass = Repository.lookupClass((String)signatureDot);
                        if (!this.castTo.contains(to) && !Repository.instanceOf((JavaClass)signatureClass, (JavaClass)toClass)) {
                            if (!Repository.instanceOf((JavaClass)toClass, (JavaClass)signatureClass) && (!toClass.isInterface() && !signatureClass.isInterface() || signatureClass.isFinal() || toClass.isFinal())) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, seen == 192 ? "BC_IMPOSSIBLE_CAST" : "BC_IMPOSSIBLE_INSTANCEOF", seen == 192 ? 1 : 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this).addClass(signatureDot).addClass(toDot));
                            } else if (seen == 192) {
                                int reg;
                                int priority = 2;
                                if (Repository.instanceOf((JavaClass)toClass, (JavaClass)signatureClass)) {
                                    priority += 2;
                                }
                                if (this.getThisClass().equals((Object)toClass) || this.getThisClass().equals((Object)signatureClass)) {
                                    ++priority;
                                }
                                if (toClass.isInterface()) {
                                    ++priority;
                                }
                                if (priority <= 3 && (signatureClass.isInterface() || signatureClass.isAbstract())) {
                                    ++priority;
                                }
                                if (this.concreteCollectionClasses.contains(signature) || this.abstractCollectionClasses.contains(signature)) {
                                    --priority;
                                }
                                if (this.concreteCollectionClasses.contains(to) || this.abstractCollectionClasses.contains(to)) {
                                    --priority;
                                }
                                if ((reg = it.getRegisterNumber()) >= 0 && reg < this.parameters && it.isInitialParameter() && this.getMethod().isPublic() && this.getPC() < 4 && --priority > 3) {
                                    --priority;
                                }
                                if (this.getMethodName().equals("compareTo")) {
                                    ++priority;
                                }
                                if (priority < 1) {
                                    priority = 1;
                                }
                                if (priority <= 3) {
                                    String bug = "BC_UNCONFIRMED_CAST";
                                    if (this.concreteCollectionClasses.contains(to)) {
                                        bug = "BC_BAD_CAST_TO_CONCRETE_COLLECTION";
                                    } else if (this.abstractCollectionClasses.contains(to) && (signature.equals("java/util/Collection") || signature.equals("java/lang/Iterable"))) {
                                        bug = "BC_BAD_CAST_TO_ABSTRACT_COLLECTION";
                                    }
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, bug, priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this).addClass(signatureDot).addClass(toDot));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (seen == 193) {
                String to = this.getClassConstantOperand();
                this.castTo.add(to);
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    private void printOpCode(int seen) {
        System.out.print("  FindBadCast: [" + this.getPC() + "]  " + OPCODE_NAMES[seen]);
        if (seen == 182 || seen == 183 || seen == 185 || seen == 184) {
            System.out.print("   " + this.getClassConstantOperand() + "." + this.getNameConstantOperand() + " " + this.getSigConstantOperand());
        } else if (seen == 18 || seen == 19 || seen == 20) {
            Constant c = this.getConstantRefOperand();
            if (c instanceof ConstantString) {
                System.out.print("   \"" + this.getStringConstantOperand() + "\"");
            } else if (c instanceof ConstantClass) {
                System.out.print("   " + this.getClassConstantOperand());
            } else {
                System.out.print("   " + c);
            }
        } else if (seen == 25 || seen == 58) {
            System.out.print("   " + this.getRegisterOperand());
        } else if (seen == 167 || seen == 200 || seen == 165 || seen == 166 || seen == 159 || seen == 162 || seen == 163 || seen == 164 || seen == 161 || seen == 160 || seen == 153 || seen == 156 || seen == 157 || seen == 158 || seen == 155 || seen == 154 || seen == 199 || seen == 198) {
            System.out.print("   " + this.getBranchTarget());
        } else if (seen == 187 || seen == 193) {
            System.out.print("   " + this.getClassConstantOperand());
        } else if (seen == 170 || seen == 171) {
            System.out.print("    [");
            int switchPC = this.getPC();
            int[] offsets = this.getSwitchOffsets();
            for (int i = 0; i < offsets.length; ++i) {
                System.out.print(switchPC + offsets[i] + ",");
            }
            System.out.print(switchPC + this.getDefaultSwitchOffset() + "]");
        }
        System.out.println();
    }
}

