/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class FindBugsSummaryStats
extends PreorderVisitor
implements Detector,
BugReporterObserver {
    private ProjectStats stats;

    public FindBugsSummaryStats(BugReporter bugReporter) {
        this.stats = bugReporter.getProjectStats();
        bugReporter.addObserver((BugReporterObserver)this);
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
        this.stats.addClass(this.getDottedClassName(), obj.isInterface(), this.calculateClassSize(obj));
    }

    private int calculateClassSize(JavaClass obj) {
        int result = 8;
        result += 8 * obj.getFields().length;
        Method[] methods = obj.getMethods();
        result += 8 * methods.length;
        int i = methods.length;
        while (--i >= 0) {
            Code code = methods[i].getCode();
            if (code == null) continue;
            result += code.getCode().length;
        }
        return result;
    }

    public void reportBug(BugInstance bug) {
        this.stats.addBug(bug);
    }
}

