/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindDoubleCheck
extends BytecodeScanningDetector
implements Constants2 {
    static final boolean debug = false;
    int stage = 0;
    int startPC;
    int endPC;
    int count;
    boolean sawMonitorEnter;
    Set<FieldAnnotation> fields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> twice = new HashSet<FieldAnnotation>();
    FieldAnnotation pendingFieldLoad;
    int countSinceGetReference;
    int countSinceGetBoolean;
    private BugReporter bugReporter;

    public FindDoubleCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.fields.clear();
        this.twice.clear();
        this.stage = 0;
        this.count = 0;
        this.countSinceGetReference = 1000;
        this.countSinceGetBoolean = 1000;
        this.sawMonitorEnter = false;
        this.pendingFieldLoad = null;
    }

    public void sawOpcode(int seen) {
        if (seen == 194) {
            this.sawMonitorEnter = true;
        }
        if (seen == 180 || seen == 178) {
            this.pendingFieldLoad = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
            String sig = this.getSigConstantOperand();
            if (sig.equals("Z")) {
                this.countSinceGetBoolean = 0;
                ++this.countSinceGetReference;
            } else if (sig.startsWith("L") || sig.startsWith("[")) {
                ++this.countSinceGetBoolean;
                this.countSinceGetReference = 0;
            }
        } else {
            ++this.countSinceGetReference;
        }
        switch (this.stage) {
            case 0: {
                int b;
                if (!((seen != 198 && seen != 199 || this.countSinceGetReference >= 5) && (seen != 153 && seen != 154 || this.countSinceGetBoolean >= 5) || (b = this.getBranchOffset()) <= 0 || seen == 198 && b > 9 || seen == 153 && b > 9 && b < 34 || seen == 154 && b > 9 && b < 34 || this.sawMonitorEnter)) {
                    this.fields.add(this.pendingFieldLoad);
                    this.startPC = this.getPC();
                    this.stage = 1;
                }
                this.count = 0;
                break;
            }
            case 1: {
                if (seen == 194) {
                    this.stage = 2;
                    this.count = 0;
                    break;
                }
                if ((seen == 198 || seen == 199) && this.countSinceGetReference < 5 || (seen == 153 || seen == 154) && this.countSinceGetBoolean < 5) {
                    int b = this.getBranchOffset();
                    if (b <= 0 || seen != 199 && b >= 10) break;
                    this.fields.add(this.pendingFieldLoad);
                    this.startPC = this.getPC();
                    this.count = 0;
                    break;
                }
                ++this.count;
                if (this.count <= 10) break;
                this.stage = 0;
                break;
            }
            case 2: {
                if (((seen == 198 || seen == 199) && this.countSinceGetReference < 5 || (seen == 153 || seen == 154) && this.countSinceGetBoolean < 5) && this.getBranchOffset() >= 0 && this.fields.contains(this.pendingFieldLoad)) {
                    this.endPC = this.getPC();
                    ++this.stage;
                    this.twice.add(this.pendingFieldLoad);
                    break;
                }
                ++this.count;
                if (this.count <= 10) break;
                this.stage = 0;
                break;
            }
            case 3: {
                FieldAnnotation f;
                if (seen != 181 && seen != 179 || !this.twice.contains(f = FieldAnnotation.fromReferencedField((DismantleBytecode)this)) || this.getNameConstantOperand().startsWith("class$") || this.getSigConstantOperand().equals("Ljava/lang/String;")) break;
                Field declaration = this.findField(this.getClassConstantOperand(), this.getNameConstantOperand());
                if (declaration == null || !declaration.isVolatile()) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "DC_DOUBLECHECK", 2).addClassAndMethod((PreorderVisitor)this).addField(f).describe("FIELD_ON").addSourceLineRange((PreorderVisitor)this, this.startPC, this.endPC));
                }
                ++this.stage;
                break;
            }
        }
    }

    Field findField(String className, String fieldName) {
        try {
            JavaClass fieldDefinedIn = this.getThisClass();
            if (!className.equals(this.getClassName())) {
                fieldDefinedIn = Repository.lookupClass((String)className);
            }
            Field[] f = fieldDefinedIn.getFields();
            for (int i = 0; i < f.length; ++i) {
                if (!f[i].getName().equals(fieldName)) continue;
                return f[i];
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

