/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Method;

public class FindFloatEquality
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    private static final int SAW_NOTHING = 0;
    private static final int SAW_COMP = 1;
    private BugReporter bugReporter;
    private OpcodeStack opStack = new OpcodeStack();
    private int state;

    public FindFloatEquality(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Method obj) {
        this.opStack.resetForMethodEntry((PreorderVisitor)this);
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sawOpcode(int seen) {
        try {
            switch (seen) {
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    if (this.opStack.getStackDepth() >= 2) {
                        OpcodeStack.Item first = this.opStack.getStackItem(0);
                        OpcodeStack.Item second = this.opStack.getStackItem(1);
                        this.state = 0;
                        Number n1 = (Number)first.getConstant();
                        Number n2 = (Number)second.getConstant();
                        if (n1 != null && n1.doubleValue() == 0.0) {
                            return;
                        }
                        if (n2 != null && n2.doubleValue() == 0.0) {
                            return;
                        }
                    }
                    this.state = 1;
                    return;
                }
                case 153: 
                case 154: {
                    if (this.state == 1) {
                        this.bugReporter.reportBug(new BugInstance("FE_FLOATING_POINT_EQUALITY", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
                    }
                    this.state = 0;
                    return;
                }
                default: {
                    this.state = 0;
                    return;
                }
            }
        }
        finally {
            this.opStack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

