/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindHEmismatch
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    boolean hasFields = false;
    boolean visibleOutsidePackage = false;
    boolean hasHashCode = false;
    boolean hasEqualsObject = false;
    boolean hashCodeIsAbstract = false;
    boolean equalsObjectIsAbstract = false;
    boolean equalsMethodIsInstanceOfEquals = false;
    boolean hasCompareToObject = false;
    boolean hasEqualsSelf = false;
    boolean hasCompareToSelf = false;
    boolean extendsObject = false;
    private BugReporter bugReporter;

    public FindHEmismatch(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitAfter(JavaClass obj) {
        if (!obj.isClass()) {
            return;
        }
        if (this.getDottedClassName().equals("java.lang.Object")) {
            return;
        }
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 0x200) != 0) {
            return;
        }
        this.visibleOutsidePackage = obj.isPublic() || obj.isProtected();
        String whereEqual = this.getDottedClassName();
        boolean classThatDefinesEqualsIsAbstract = false;
        boolean inheritedHashCodeIsFinal = false;
        boolean inheritedEqualsIsFinal = false;
        boolean inheritedEqualsIsAbstract = false;
        if (!this.hasEqualsObject) {
            JavaClass we = Lookup.findSuperImplementor((JavaClass)obj, (String)"equals", (String)"(Ljava/lang/Object;)Z", (BugReporter)this.bugReporter);
            if (we == null) {
                whereEqual = "java.lang.Object";
            } else {
                whereEqual = we.getClassName();
                classThatDefinesEqualsIsAbstract = we.isAbstract();
                Method m = this.findMethod(we, "equals", "(Ljava/lang/Object;)Z");
                if (m != null && m.isFinal()) {
                    inheritedEqualsIsFinal = true;
                }
                if (m != null && m.isAbstract()) {
                    inheritedEqualsIsAbstract = true;
                }
            }
        }
        boolean usesDefaultEquals = whereEqual.equals("java.lang.Object");
        String whereHashCode = this.getDottedClassName();
        if (!this.hasHashCode) {
            JavaClass wh = Lookup.findSuperImplementor((JavaClass)obj, (String)"hashCode", (String)"()I", (BugReporter)this.bugReporter);
            if (wh == null) {
                whereHashCode = "java.lang.Object";
            } else {
                whereHashCode = wh.getClassName();
                Method m = this.findMethod(wh, "hashCode", "()I");
                if (m != null && m.isFinal()) {
                    inheritedHashCodeIsFinal = true;
                }
            }
        }
        boolean usesDefaultHashCode = whereHashCode.equals("java.lang.Object");
        if (!this.hasEqualsObject && this.hasEqualsSelf) {
            if (usesDefaultEquals) {
                int priority = 1;
                if (usesDefaultHashCode || obj.isAbstract()) {
                    ++priority;
                }
                if (!this.visibleOutsidePackage) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_SELF_USE_OBJECT", priority).addClass(this.getDottedClassName()));
            } else {
                int priority = 2;
                if (this.hasFields) {
                    --priority;
                }
                if (obj.isAbstract()) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_SELF_NO_OBJECT", priority).addClass(this.getDottedClassName()));
            }
        }
        if (!this.hasCompareToObject && this.hasCompareToSelf && !this.extendsObject) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "CO_SELF_NO_OBJECT", 2).addClass(this.getDottedClassName()));
        }
        if (this.hasHashCode && !this.hashCodeIsAbstract && !this.hasEqualsObject && !this.hasEqualsSelf) {
            int priority = 3;
            if (usesDefaultEquals) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_HASHCODE_USE_OBJECT_EQUALS", priority).addClass(this.getDottedClassName()));
            } else if (!inheritedEqualsIsFinal) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_HASHCODE_NO_EQUALS", priority).addClass(this.getDottedClassName()));
            }
        }
        if (!this.hasHashCode && (this.hasEqualsObject && !this.equalsObjectIsAbstract || this.hasEqualsSelf)) {
            if (usesDefaultHashCode) {
                int priority = 1;
                if (this.equalsMethodIsInstanceOfEquals) {
                    priority += 2;
                } else if (obj.isAbstract() || !this.hasEqualsObject) {
                    ++priority;
                }
                if (!this.visibleOutsidePackage) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_EQUALS_USE_HASHCODE", priority).addClass(this.getDottedClassName()));
            } else if (!inheritedHashCodeIsFinal) {
                int priority = 3;
                if (this.hasEqualsObject && inheritedEqualsIsAbstract) {
                    ++priority;
                }
                if (this.hasFields) {
                    --priority;
                }
                if (this.equalsMethodIsInstanceOfEquals || !this.hasEqualsObject) {
                    priority += 2;
                } else if (obj.isAbstract()) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_EQUALS_NO_HASHCODE", priority).addClass(this.getDottedClassName()));
            }
        }
        if (!(this.hasHashCode || this.hasEqualsObject || this.hasEqualsSelf || usesDefaultEquals || !usesDefaultHashCode || obj.isAbstract() || !classThatDefinesEqualsIsAbstract)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_INHERITS_EQUALS_USE_HASHCODE", 2).addClass(this.getDottedClassName()));
        }
    }

    public void visit(JavaClass obj) {
        this.extendsObject = this.getDottedSuperclassName().equals("java.lang.Object");
        this.hasFields = false;
        this.hasHashCode = false;
        this.hasCompareToObject = false;
        this.hasCompareToSelf = false;
        this.hasEqualsObject = false;
        this.hasEqualsSelf = false;
        this.hashCodeIsAbstract = false;
        this.equalsObjectIsAbstract = false;
        this.equalsMethodIsInstanceOfEquals = false;
    }

    public void visit(Field obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        if (!obj.getName().startsWith("this$")) {
            this.hasFields = true;
        }
    }

    public void visit(Method obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        String name = obj.getName();
        String sig = obj.getSignature();
        if ((accessFlags & 0x400) != 0) {
            if (name.equals("equals") && sig.equals("(L" + this.getClassName() + ";)Z")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_ABSTRACT_SELF", 3).addClass(this.getDottedClassName()));
                return;
            }
            if (name.equals("compareTo") && sig.equals("(L" + this.getClassName() + ";)I")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "CO_ABSTRACT_SELF", 3).addClass(this.getDottedClassName()));
                return;
            }
        }
        boolean sigIsObject = sig.equals("(Ljava/lang/Object;)Z");
        if (name.equals("hashCode") && sig.equals("()I")) {
            this.hasHashCode = true;
            if (obj.isAbstract()) {
                this.hashCodeIsAbstract = true;
            }
        } else if (name.equals("equals")) {
            if (sigIsObject) {
                Code code;
                byte[] codeBytes;
                this.hasEqualsObject = true;
                if (obj.isAbstract()) {
                    this.equalsObjectIsAbstract = true;
                } else if (!obj.isNative() && ((codeBytes = (code = obj.getCode()).getCode()).length == 5 && (codeBytes[1] & 0xFF) == 193 || codeBytes.length == 15 && (codeBytes[1] & 0xFF) == 193 && (codeBytes[11] & 0xFF) == 183)) {
                    this.equalsMethodIsInstanceOfEquals = true;
                }
            } else if (sig.equals("(L" + this.getClassName() + ";)Z")) {
                this.hasEqualsSelf = true;
            }
        } else if (name.equals("compareTo")) {
            if (sig.equals("(Ljava/lang/Object;)I")) {
                this.hasCompareToObject = true;
            } else if (sig.equals("(L" + this.getClassName() + ";)I")) {
                this.hasCompareToSelf = true;
            }
        }
    }

    Method findMethod(JavaClass clazz, String name, String sig) {
        Method[] m = clazz.getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().equals(name) || !m[i].getSignature().equals(sig)) continue;
            return m[i];
        }
        return null;
    }
}

