/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class FindLocalSelfAssignment2
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    private BugReporter bugReporter;
    private int previousLoadOf = -1;

    public FindLocalSelfAssignment2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Code obj) {
        this.previousLoadOf = -1;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (this.isRegisterLoad()) {
            this.previousLoadOf = this.getRegisterOperand();
        } else {
            if (this.isRegisterStore() && this.previousLoadOf == this.getRegisterOperand()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SA_LOCAL_SELF_ASSIGNMENT", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
            }
            this.previousLoadOf = -1;
        }
    }
}

