/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.detect.Analyze;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindNonSerializableStoreIntoSession
implements Detector {
    private BugReporter bugReporter;
    private static final boolean DEBUG = false;

    public FindNonSerializableStoreIntoSession(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList = classContext.getJavaClass().getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
            }
        }
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet.get(192) || bytecodeSet.get(193);
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        int firstParam;
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        ValueNumberFrame vnaFrameAtEntry = (ValueNumberFrame)vnaDataflow.getStartFact(cfg.getEntry());
        HashSet<Object> paramValueNumberSet = new HashSet<Object>();
        for (int i = firstParam = method.isStatic() ? 0 : 1; i < vnaFrameAtEntry.getNumLocals(); ++i) {
            paramValueNumberSet.add(vnaFrameAtEntry.getValue(i));
        }
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            ReferenceType refType;
            Type operandType;
            TypeFrame frame;
            String cName;
            INVOKEINTERFACE invoke;
            String mName;
            Location location = (Location)i.next();
            InstructionHandle handle = location.getHandle();
            int pc = handle.getPosition();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof INVOKEINTERFACE) || !(mName = (invoke = (INVOKEINTERFACE)ins).getMethodName(cpg)).equals("setAttribute") || !(cName = invoke.getClassName(cpg)).equals("javax.servlet.http.HttpSession") || !(frame = typeDataflow.getFactAtLocation(location)).isValid() || (operandType = (Type)frame.getTopValue()).equals(TopType.instance()) || !(operandType instanceof ReferenceType) || (refType = (ReferenceType)operandType).equals(NullType.instance())) continue;
            String refSig = refType.getSignature();
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
            ValueNumberFrame vFrame = vnaDataflow.getFactAtLocation(location);
            boolean isParameter = paramValueNumberSet.contains(vFrame.getTopValue());
            try {
                double isSerializable = Analyze.isDeepSerializable(refSig);
                if (!(isSerializable < 0.9)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "J2EE_STORE_OF_NON_SERIALIZABLE_OBJECT_INTO_SESSION", isSerializable < 0.15 ? 1 : (isSerializable > 0.5 ? 3 : 2)).addClassAndMethod(methodGen, sourceFile).addSourceLine(sourceLineAnnotation).addClass(Analyze.getComponentClass(refSig)));
            }
            catch (ClassNotFoundException e) {}
        }
    }

    public void report() {
    }
}

