/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowValueChooser;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.JavaClassAndMethodChooser;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodFactory;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.MayReturnNullPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.NonNullContractCollector;
import edu.umd.cs.findbugs.ba.npe.NonNullParamProperty;
import edu.umd.cs.findbugs.ba.npe.NonNullParamPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.NonNullParamViolation;
import edu.umd.cs.findbugs.ba.npe.NonNullReturnValueAnnotationChecker;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonCollector;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonFinder;
import edu.umd.cs.findbugs.ba.npe.RedundantBranch;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.detect.NonNullReturnProperty;
import edu.umd.cs.findbugs.detect.NullArgumentWarningProperty;
import edu.umd.cs.findbugs.detect.NullDerefProperty;
import edu.umd.cs.findbugs.props.GeneralWarningProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNullDeref
implements Detector,
NullDerefAndRedundantComparisonCollector {
    private static final boolean DEBUG = Boolean.getBoolean("fnd.debug");
    private static final boolean DEBUG_NULLARG = Boolean.getBoolean("fnd.debug.nullarg");
    private static final boolean DEBUG_NULLRETURN = Boolean.getBoolean("fnd.debug.nullreturn");
    private static final boolean REPORT_SAFE_METHOD_TARGETS = true;
    private static final String METHOD = System.getProperty("fnd.method");
    private BugReporter bugReporter;
    private NonNullParamPropertyDatabase unconditionalDerefParamDatabase;
    private NonNullParamPropertyDatabase nonNullParamDatabase;
    private NonNullParamPropertyDatabase possiblyNullParamDatabase;
    private MayReturnNullPropertyDatabase nullReturnValueAnnotationDatabase;
    private boolean checkedDatabases;
    private boolean checkUnconditionalDeref;
    private boolean checkParamAnnotations;
    private boolean checkReturnValueAnnotations;
    private boolean checkCallSites;
    private boolean checkCallSitesOrReturnInstructions;
    private ClassContext classContext;
    private Method method;
    private JavaClassAndMethod nonNullReturn;

    public FindNullDeref(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        try {
            JavaClass jclass = classContext.getJavaClass();
            Method[] methodList = jclass.getMethods();
            for (int i = 0; i < methodList.length; ++i) {
                Method method = methodList[i];
                if (method.isAbstract() || method.isNative() || method.getCode() == null || METHOD != null && !method.getName().equals(METHOD)) continue;
                this.analyzeMethod(classContext, method);
            }
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("FindNullDeref caught exception", (Throwable)e);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("FindNullDeref caught exception", (Throwable)e);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        if (!this.checkedDatabases) {
            this.checkDatabases();
            this.checkedDatabases = true;
        }
        this.method = method;
        if (this.checkReturnValueAnnotations) {
            this.checkForNonNullAnnotation();
        }
        if (DEBUG || DEBUG_NULLARG) {
            System.out.println(SignatureConverter.convertMethodSignature((MethodGen)classContext.getMethodGen(method)));
        }
        IsNullValueDataflow invDataflow = classContext.getIsNullValueDataflow(method);
        NullDerefAndRedundantComparisonFinder worker = new NullDerefAndRedundantComparisonFinder(classContext, method, invDataflow, (NullDerefAndRedundantComparisonCollector)this);
        worker.execute();
        if (this.checkUnconditionalDeref || this.checkParamAnnotations || this.checkReturnValueAnnotations) {
            this.checkCallSitesAndReturnInstructions();
        }
    }

    private void checkDatabases() {
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        this.unconditionalDerefParamDatabase = analysisContext.getUnconditionalDerefParamDatabase();
        this.nonNullParamDatabase = analysisContext.getNonNullParamDatabase();
        this.possiblyNullParamDatabase = analysisContext.getPossiblyNullParamDatabase();
        this.nullReturnValueAnnotationDatabase = analysisContext.getNullReturnValueAnnotationDatabase();
        this.checkUnconditionalDeref = this.isDatabaseNonEmpty(this.unconditionalDerefParamDatabase);
        this.checkParamAnnotations = this.isDatabaseNonEmpty(this.nonNullParamDatabase) && this.isDatabaseNonEmpty(this.possiblyNullParamDatabase);
        this.checkReturnValueAnnotations = this.isDatabaseNonEmpty(this.nullReturnValueAnnotationDatabase);
        this.checkCallSites = this.checkUnconditionalDeref || this.checkParamAnnotations;
        this.checkCallSitesOrReturnInstructions = this.checkCallSites || this.checkReturnValueAnnotations;
    }

    private <DatabaseType extends PropertyDatabase<?, ?>> boolean isDatabaseNonEmpty(DatabaseType database) {
        return database != null && !database.isEmpty();
    }

    private void checkForNonNullAnnotation() {
        this.nonNullReturn = null;
        if (this.method.getSignature().indexOf(")L") >= 0) {
            if (DEBUG_NULLRETURN) {
                System.out.println(new StringBuffer().append("Checking return annotation for ").append(SignatureConverter.convertMethodSignature((JavaClass)this.classContext.getJavaClass(), (Method)this.method)).toString());
            }
            NonNullReturnValueAnnotationChecker annotationChecker = new NonNullReturnValueAnnotationChecker(this.nullReturnValueAnnotationDatabase);
            try {
                JavaClassAndMethod classAndMethod = new JavaClassAndMethod(this.classContext.getJavaClass(), this.method);
                annotationChecker.choose(classAndMethod);
                if (annotationChecker.getProperty() == null) {
                    Hierarchy.visitSuperClassMethods((JavaClassAndMethod)classAndMethod, (JavaClassAndMethodChooser)annotationChecker);
                }
                if (annotationChecker.getProperty() == null) {
                    Hierarchy.visitSuperInterfaceMethods((JavaClassAndMethod)classAndMethod, (JavaClassAndMethodChooser)annotationChecker);
                }
                if (annotationChecker.getProperty() != null && !annotationChecker.getProperty().booleanValue()) {
                    this.nonNullReturn = annotationChecker.getAnnotatedMethod();
                }
                if (DEBUG_NULLRETURN && this.nonNullReturn != null) {
                    System.out.println(new StringBuffer().append("\t==> found: ").append(this.nonNullReturn).toString());
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    private void checkCallSitesAndReturnInstructions() throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = this.classContext.getConstantPoolGen();
        TypeDataflow typeDataflow = this.classContext.getTypeDataflow(this.method);
        Iterator i = this.classContext.getCFG(this.method).locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            Instruction ins = location.getHandle().getInstruction();
            try {
                if (this.checkCallSites && ins instanceof InvokeInstruction) {
                    this.examineCallSite(location, cpg, typeDataflow);
                    continue;
                }
                if (!this.checkReturnValueAnnotations || this.nonNullReturn == null || ins.getOpcode() != 176) continue;
                this.examineReturnInstruction(location);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    private void examineCallSite(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow) throws DataflowAnalysisException, CFGBuilderException, ClassNotFoundException {
        InvokeInstruction invokeInstruction = (InvokeInstruction)location.getHandle().getInstruction();
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Examining call site: ").append(location.getHandle()).toString());
        }
        String methodName = invokeInstruction.getName(cpg);
        String signature = invokeInstruction.getSignature(cpg);
        if (methodName.equals("equals") && signature.equals("(Ljava/lang/Object;)Z")) {
            return;
        }
        int returnTypeStart = signature.indexOf(41);
        if (returnTypeStart < 0) {
            return;
        }
        String paramList = signature.substring(0, returnTypeStart + 1);
        if (paramList.equals("()") || paramList.indexOf("L") < 0 && paramList.indexOf(91) < 0) {
            return;
        }
        IsNullValueFrame frame = this.classContext.getIsNullValueDataflow(this.method).getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        BitSet nullArgSet = frame.getArgumentSet(invokeInstruction, cpg, (DataflowValueChooser)new DataflowValueChooser<IsNullValue>(){

            public boolean choose(IsNullValue value) {
                return value.mightBeNull() && !value.isException();
            }

            public /* synthetic */ boolean choose(Object x0) {
                return this.choose((IsNullValue)x0);
            }
        });
        BitSet definitelyNullArgSet = frame.getArgumentSet(invokeInstruction, cpg, (DataflowValueChooser)new DataflowValueChooser<IsNullValue>(){

            public boolean choose(IsNullValue value) {
                return value.isDefinitelyNull();
            }

            public /* synthetic */ boolean choose(Object x0) {
                return this.choose((IsNullValue)x0);
            }
        });
        if (nullArgSet.isEmpty()) {
            return;
        }
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Null arguments passed: ").append(nullArgSet).toString());
        }
        if (this.unconditionalDerefParamDatabase != null) {
            this.checkUnconditionallyDereferencedParam(location, cpg, typeDataflow, invokeInstruction, nullArgSet, definitelyNullArgSet);
        }
        if (this.nonNullParamDatabase != null && this.possiblyNullParamDatabase != null) {
            if (DEBUG_NULLARG) {
                System.out.println("Checking nonnull params");
            }
            this.checkNonNullParam(location, cpg, typeDataflow, invokeInstruction, nullArgSet, definitelyNullArgSet);
        }
    }

    private void examineReturnInstruction(Location location) throws DataflowAnalysisException, CFGBuilderException {
        IsNullValueDataflow invDataflow;
        IsNullValueFrame frame;
        if (DEBUG_NULLRETURN) {
            System.out.println(new StringBuffer().append("Checking null return at ").append(location).toString());
        }
        if (!(frame = (invDataflow = this.classContext.getIsNullValueDataflow(this.method)).getFactAtLocation(location)).isValid()) {
            return;
        }
        IsNullValue tos = (IsNullValue)frame.getTopValue();
        if (tos.mightBeNull()) {
            MethodGen methodGen = this.classContext.getMethodGen(this.method);
            String sourceFile = this.classContext.getJavaClass().getSourceFileName();
            WarningPropertySet propertySet = new WarningPropertySet();
            BugInstance warning = new BugInstance("NP_NONNULL_RETURN_VIOLATION", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, location.getHandle()).addMethod(this.nonNullReturn.getJavaClass(), this.nonNullReturn.getMethod()).describe("METHOD_DECLARED_NONNULL");
            JavaClassAndMethod visitedMethod = new JavaClassAndMethod(this.classContext.getJavaClass(), this.method);
            if (visitedMethod.equals((Object)this.nonNullReturn)) {
                propertySet.addProperty((WarningProperty)NonNullReturnProperty.EXACT_METHOD);
            }
            int priority = propertySet.computePriority(2);
            if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)this.classContext, (Method)this.method, (Location)location);
                propertySet.decorateBugInstance(warning);
            }
            this.bugReporter.reportBug(warning);
        }
    }

    private void checkUnconditionallyDereferencedParam(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow, InvokeInstruction invokeInstruction, BitSet nullArgSet, BitSet definitelyNullArgSet) throws DataflowAnalysisException, ClassNotFoundException {
        int priority;
        String bugType;
        TypeFrame typeFrame = typeDataflow.getFactAtLocation(location);
        Set targetMethodSet = Hierarchy.resolveMethodCallTargets((InvokeInstruction)invokeInstruction, (TypeFrame)typeFrame, (ConstantPoolGen)cpg);
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Possibly called methods: ").append(targetMethodSet).toString());
        }
        BitSet unconditionallyDereferencedNullArgSet = new BitSet();
        LinkedList<JavaClassAndMethod> dangerousCallTargetList = new LinkedList<JavaClassAndMethod>();
        for (JavaClassAndMethod targetMethod : targetMethodSet) {
            BitSet targetUnconditionallyDereferencedNullArgSet;
            NonNullParamProperty property;
            if (DEBUG_NULLARG) {
                System.out.println(new StringBuffer().append("For target method ").append(targetMethod).toString());
            }
            if ((property = (NonNullParamProperty)this.unconditionalDerefParamDatabase.getProperty((Object)targetMethod.toXMethod())) == null) continue;
            if (DEBUG_NULLARG) {
                System.out.println(new StringBuffer().append("\tUnconditionally dereferenced params: ").append(property).toString());
            }
            if ((targetUnconditionallyDereferencedNullArgSet = property.getViolatedParamSet(nullArgSet)).isEmpty()) continue;
            dangerousCallTargetList.add(targetMethod);
            unconditionallyDereferencedNullArgSet.or(targetUnconditionallyDereferencedNullArgSet);
        }
        if (dangerousCallTargetList.isEmpty()) {
            return;
        }
        WarningPropertySet propertySet = new WarningPropertySet();
        HashSet safeCallTargetSet = new HashSet();
        safeCallTargetSet.addAll(targetMethodSet);
        safeCallTargetSet.removeAll(dangerousCallTargetList);
        if (safeCallTargetSet.isEmpty()) {
            propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.ALL_DANGEROUS_TARGETS);
            if (dangerousCallTargetList.size() == 1) {
                propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.MONOMORPHIC_CALL_SITE);
            }
        }
        boolean privateCall = safeCallTargetSet.isEmpty() && dangerousCallTargetList.size() == 1 && ((JavaClassAndMethod)dangerousCallTargetList.get(0)).getMethod().isPrivate();
        MethodGen methodGen = this.classContext.getMethodGen(this.method);
        String sourceFile = this.classContext.getJavaClass().getSourceFileName();
        if (privateCall || invokeInstruction.getOpcode() == 184 || invokeInstruction.getOpcode() == 183) {
            bugType = "NP_NULL_PARAM_DEREF_NONVIRTUAL";
            priority = 1;
        } else if (safeCallTargetSet.isEmpty()) {
            bugType = "NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS";
            priority = 2;
        } else {
            bugType = "NP_NULL_PARAM_DEREF";
            priority = 3;
        }
        BugInstance warning = new BugInstance(bugType, priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, location.getHandle()).addMethod(XMethodFactory.createXMethod((InvokeInstruction)invokeInstruction, (ConstantPoolGen)cpg)).describe("METHOD_CALLED");
        this.addParamAnnotations(definitelyNullArgSet, unconditionallyDereferencedNullArgSet, propertySet, warning);
        for (JavaClassAndMethod dangerousCallTarget : dangerousCallTargetList) {
            warning.addMethod(dangerousCallTarget).describe("METHOD_DANGEROUS_TARGET");
        }
        for (JavaClassAndMethod safeMethod : safeCallTargetSet) {
            warning.addMethod(safeMethod).describe("METHOD_SAFE_TARGET");
        }
        this.decorateWarning(location, propertySet, warning);
        this.bugReporter.reportBug(warning);
    }

    private void decorateWarning(Location location, WarningPropertySet propertySet, BugInstance warning) {
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)this.classContext, (Method)this.method, (Location)location);
        }
        propertySet.decorateBugInstance(warning);
    }

    private void addParamAnnotations(BitSet definitelyNullArgSet, BitSet violatedParamSet, WarningPropertySet propertySet, BugInstance warning) {
        for (int i = 0; i < 32; ++i) {
            if (!violatedParamSet.get(i)) continue;
            boolean definitelyNull = definitelyNullArgSet.get(i);
            if (definitelyNull) {
                propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.ARG_DEFINITELY_NULL);
            }
            warning.addInt(i + 1).describe(definitelyNull ? "INT_NULL_ARG" : "INT_MAYBE_NULL_ARG");
        }
    }

    private void checkNonNullParam(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow, InvokeInstruction invokeInstruction, BitSet nullArgSet, BitSet definitelyNullArgSet) throws ClassNotFoundException {
        NonNullContractCollector nonNullContractCollector = new NonNullContractCollector(this.nonNullParamDatabase, this.possiblyNullParamDatabase);
        nonNullContractCollector.findContractForCallSite(invokeInstruction, cpg);
        int numParams = new SignatureParser(invokeInstruction.getSignature(cpg)).getNumParameters();
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Checking ").append(numParams).append(" parameter(s)").toString());
        }
        BitSet violatedParamSet = new BitSet();
        LinkedList violationList = new LinkedList();
        nonNullContractCollector.getViolationList(numParams, nullArgSet, violationList, violatedParamSet);
        if (violationList.isEmpty()) {
            return;
        }
        XMethod xmethod = XMethodFactory.createXMethod((InvokeInstruction)invokeInstruction, (ConstantPoolGen)cpg);
        WarningPropertySet propertySet = new WarningPropertySet();
        MethodGen methodGen = this.classContext.getMethodGen(this.method);
        String sourceFile = this.classContext.getJavaClass().getSourceFileName();
        BugInstance warning = new BugInstance("NP_NONNULL_PARAM_VIOLATION", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, location.getHandle()).addMethod(xmethod).describe("METHOD_CALLED");
        this.addParamAnnotations(definitelyNullArgSet, violatedParamSet, propertySet, warning);
        for (NonNullParamViolation violation : violationList) {
            warning.addMethod(violation.getClassAndMethod());
            warning.addInt(violation.getParam()).describe("INT_NONNULL_PARAM");
        }
        this.decorateWarning(location, propertySet, warning);
        this.bugReporter.reportBug(warning);
    }

    public void report() {
    }

    public void foundNullDeref(Location location, ValueNumber valueNumber, IsNullValue refValue) {
        WarningPropertySet propertySet = new WarningPropertySet();
        boolean onExceptionPath = refValue.isException();
        if (onExceptionPath) {
            propertySet.addProperty((WarningProperty)GeneralWarningProperty.ON_EXCEPTION_PATH);
        }
        if (refValue.isDefinitelyNull()) {
            String type = onExceptionPath ? "NP_ALWAYS_NULL_EXCEPTION" : "NP_ALWAYS_NULL";
            int priority = onExceptionPath ? 3 : 1;
            this.reportNullDeref(propertySet, this.classContext, this.method, location, type, priority);
        } else if (refValue.isNullOnSomePath()) {
            int priority;
            String type = onExceptionPath ? "NP_NULL_ON_SOME_PATH_EXCEPTION" : "NP_NULL_ON_SOME_PATH";
            int n = priority = onExceptionPath ? 3 : 2;
            if (refValue.isReturnValue()) {
                type = "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE";
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Reporting null on some path: value=").append(refValue).toString());
            }
            this.reportNullDeref(propertySet, this.classContext, this.method, location, type, priority);
        }
    }

    private void reportNullDeref(WarningPropertySet propertySet, ClassContext classContext, Method method, Location location, String type, int priority) {
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        BugInstance bugInstance = new BugInstance((Detector)this, type, priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, location.getHandle());
        if (DEBUG) {
            bugInstance.addInt(location.getHandle().getPosition()).describe("INT_BYTECODE_OFFSET");
        }
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)classContext, (Method)method, (Location)location);
            propertySet.decorateBugInstance(bugInstance);
        }
        this.bugReporter.reportBug(bugInstance);
    }

    public void foundRedundantNullCheck(Location location, RedundantBranch redundantBranch) {
        String warning;
        String sourceFile = this.classContext.getJavaClass().getSourceFileName();
        MethodGen methodGen = this.classContext.getMethodGen(this.method);
        boolean isChecked = redundantBranch.firstValue.isChecked();
        boolean wouldHaveBeenAKaboom = redundantBranch.firstValue.wouldHaveBeenAKaboom();
        int priority = 3;
        if (redundantBranch.secondValue == null) {
            warning = redundantBranch.firstValue.isDefinitelyNull() ? "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE" : "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE";
        } else {
            boolean bothNull = redundantBranch.firstValue.isDefinitelyNull() && redundantBranch.secondValue.isDefinitelyNull();
            warning = bothNull ? "RCN_REDUNDANT_COMPARISON_TWO_NULL_VALUES" : "RCN_REDUNDANT_COMPARISON_OF_NULL_AND_NONNULL_VALUE";
            if (redundantBranch.secondValue.isChecked()) {
                isChecked = true;
            }
            if (redundantBranch.secondValue.wouldHaveBeenAKaboom()) {
                wouldHaveBeenAKaboom = true;
            }
        }
        if (wouldHaveBeenAKaboom) {
            priority = 1;
            warning = "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE";
        } else if (isChecked) {
            priority = 2;
        }
        BugInstance bugInstance = new BugInstance((Detector)this, warning, priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, location.getHandle());
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertySet propertySet = new WarningPropertySet();
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)this.classContext, (Method)this.method, (Location)location);
            if (isChecked) {
                propertySet.addProperty((WarningProperty)NullDerefProperty.CHECKED_VALUE);
            }
            if (wouldHaveBeenAKaboom) {
                propertySet.addProperty((WarningProperty)NullDerefProperty.WOULD_HAVE_BEEN_A_KABOOM);
            }
            propertySet.decorateBugInstance(bugInstance);
            priority = propertySet.computePriority(2);
            bugInstance.setPriority(priority);
        }
        this.bugReporter.reportBug(bugInstance);
    }
}

