/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class FindPuzzlers
extends BytecodeScanningDetector
implements Constants2 {
    BugReporter bugReporter;
    int prevOpcodeIncrementedRegister;
    int valueOfConstantArgumentToShift;
    boolean constantArgumentToShift;
    OpcodeStack stack = new OpcodeStack();

    public FindPuzzlers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Code obj) {
        this.prevOpcodeIncrementedRegister = -1;
        this.stack.resetForMethodEntry((PreorderVisitor)this);
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        int v;
        OpcodeStack.Item item;
        Object o;
        if (seen == 182 && this.getNameConstantOperand().equals("equals") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") && this.stack.getStackDepth() > 1) {
            OpcodeStack.Item item0 = this.stack.getStackItem(0);
            OpcodeStack.Item item1 = this.stack.getStackItem(1);
            if (item0.isArray() || item1.isArray()) {
                this.bugReporter.reportBug(new BugInstance("EC_BAD_ARRAY_COMPARE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
            }
        }
        if (!(seen != 153 && seen != 154 || this.getPrevOpcode(1) != 104 || this.getPrevOpcode(2) != 17 && this.getPrevOpcode(2) != 16 || this.getPrevOpcode(3) != 112)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "IM_MULTIPLYING_RESULT_OF_IREM", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        if (seen == 147 && this.getPrevOpcode(1) == 124 && (!this.constantArgumentToShift || this.valueOfConstantArgumentToShift % 16 != 0) || seen == 145 && this.getPrevOpcode(1) == 124 && (!this.constantArgumentToShift || this.valueOfConstantArgumentToShift % 8 != 0)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "ICAST_QUESTIONABLE_UNSIGNED_RIGHT_SHIFT", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        this.constantArgumentToShift = false;
        if (seen == 124 || seen == 122 || seen == 120) {
            if (this.stack.getStackDepth() <= 1) {
                this.constantArgumentToShift = true;
                this.valueOfConstantArgumentToShift = 8;
            } else {
                Object rightHandSide = this.stack.getStackItem(0).getConstant();
                Object leftHandSide = this.stack.getStackItem(1).getConstant();
                if (rightHandSide != null && rightHandSide instanceof Integer) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = (Integer)rightHandSide;
                    if (this.valueOfConstantArgumentToShift < 0 || this.valueOfConstantArgumentToShift >= 32) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "ICAST_BAD_SHIFT_AMOUNT", 2).addClassAndMethod((PreorderVisitor)this).addInt(this.valueOfConstantArgumentToShift).addSourceLine((DismantleBytecode)this));
                    }
                }
                if (leftHandSide != null && leftHandSide instanceof Integer && (Integer)leftHandSide > 0) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = 8;
                }
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && this.getClassConstantOperand().equals("java/util/Date") && this.getNameConstantOperand().equals("setDate") && this.getSigConstantOperand().equals("(I)V") && (o = (item = this.stack.getStackItem(0)).getConstant()) != null && o instanceof Integer && ((v = ((Integer)o).intValue()) < 0 || v > 11)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_BAD_MONTH", 2).addClassAndMethod((PreorderVisitor)this).addInt(v).addCalledMethod((DismantleBytecode)this).addSourceLine((DismantleBytecode)this));
        }
        if ((seen == 182 && this.stack.getStackDepth() > 1 && this.getClassConstantOperand().equals("java/util/Calendar") && this.getNameConstantOperand().equals("set") && this.getSigConstantOperand().equals("(III)V") || seen == 183 && this.stack.getStackDepth() > 1 && this.getClassConstantOperand().equals("java/util/GregorianCalendar") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("(III)V")) && (o = (item = this.stack.getStackItem(1)).getConstant()) != null && o instanceof Integer && ((v = ((Integer)o).intValue()) < 0 || v > 11)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "PZ_BAD_MONTH", 2).addClassAndMethod((PreorderVisitor)this).addInt(v).addCalledMethod((DismantleBytecode)this).addSourceLine((DismantleBytecode)this));
        }
        if (this.isRegisterStore() && (seen == 54 || seen == 59 || seen == 60 || seen == 61 || seen == 62) && this.getRegisterOperand() == this.prevOpcodeIncrementedRegister) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DLS_OVERWRITTEN_INCREMENT", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        this.prevOpcodeIncrementedRegister = seen == 132 ? this.getRegisterOperand() : -1;
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

