/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class IncompatMask
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    int state = 0;
    long arg0;
    long arg1;
    int bitop;
    private BugReporter bugReporter;

    public IncompatMask(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.state = 0;
    }

    private void checkState(int expectedState) {
        this.state = this.state == expectedState ? ++this.state : 0;
    }

    private void noteVal(long val) {
        if (this.state == 0) {
            this.arg0 = val;
        } else if (this.state == 2) {
            this.arg1 = val;
        } else {
            this.state = -1;
        }
        ++this.state;
    }

    public void sawInt(int val) {
        this.noteVal(val);
    }

    public void sawLong(long val) {
        this.noteVal(val);
    }

    public void sawOpcode(int seen) {
        String t;
        long dif;
        switch (seen) {
            case 2: {
                this.noteVal(-1L);
                return;
            }
            case 3: {
                this.noteVal(0L);
                return;
            }
            case 4: {
                this.noteVal(1L);
                return;
            }
            case 5: {
                this.noteVal(2L);
                return;
            }
            case 6: {
                this.noteVal(3L);
                return;
            }
            case 7: {
                this.noteVal(4L);
                return;
            }
            case 8: {
                this.noteVal(5L);
                return;
            }
            case 9: {
                this.noteVal(0L);
                return;
            }
            case 10: {
                this.noteVal(1L);
                return;
            }
            case 16: {
                return;
            }
            case 20: {
                return;
            }
            case 17: {
                return;
            }
            case 18: {
                return;
            }
            case 126: 
            case 127: {
                this.bitop = 126;
                this.checkState(1);
                return;
            }
            case 128: 
            case 129: {
                this.bitop = 128;
                this.checkState(1);
                return;
            }
            case 148: {
                return;
            }
            case 153: 
            case 154: {
                if (this.state == 2) {
                    this.arg1 = 0L;
                    this.state = 3;
                }
            }
            case 159: 
            case 160: {
                this.checkState(3);
                if (this.state == 4) break;
                return;
            }
            case 167: {
                this.state = -1;
                return;
            }
            default: {
                this.state = 0;
                return;
            }
        }
        if (this.bitop == 128) {
            dif = this.arg0 & (this.arg1 ^ 0xFFFFFFFFFFFFFFFFL);
            t = "BIT_IOR";
        } else if (this.arg0 != 0L || this.arg1 != 0L) {
            dif = this.arg1 & (this.arg0 ^ 0xFFFFFFFFFFFFFFFFL);
            t = "BIT_AND";
        } else {
            dif = 1L;
            t = "BIT_AND_ZZ";
        }
        if (dif != 0L) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, t, 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        this.state = 0;
    }
}

