/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.PostDominatorsAnalysis;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.heap.FieldSet;
import edu.umd.cs.findbugs.ba.heap.LoadDataflow;
import edu.umd.cs.findbugs.ba.heap.StoreDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.Type;

public class InfiniteRecursiveLoop2
implements Detector {
    private static final boolean DEBUG = Boolean.getBoolean("irl.debug");
    private static final String IRL_METHOD = System.getProperty("irl.method");
    private BugReporter bugReporter;

    public InfiniteRecursiveLoop2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList = classContext.getJavaClass().getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (method.getCode() == null || IRL_METHOD != null && !method.getName().equals(IRL_METHOD)) continue;
            try {
                if (DEBUG) {
                    System.out.println("Checking method " + SignatureConverter.convertMethodSignature((JavaClass)classContext.getJavaClass(), (Method)method));
                }
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error checking for infinite recursive loop in " + SignatureConverter.convertMethodSignature((JavaClass)classContext.getJavaClass(), (Method)method), (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error checking for infinite recursive loop in " + SignatureConverter.convertMethodSignature((JavaClass)classContext.getJavaClass(), (Method)method), (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        Iterator i = cfg.blockIterator();
        while (i.hasNext()) {
            InstructionHandle thrower;
            Instruction ins;
            BasicBlock basicBlock = (BasicBlock)i.next();
            if (!basicBlock.isExceptionThrower() || !((ins = (thrower = basicBlock.getExceptionThrower()).getInstruction()) instanceof InvokeInstruction)) continue;
            if (this.isRecursiveCall((InvokeInstruction)ins, classContext, method)) {
                this.checkRecursiveCall(classContext, method, cfg, basicBlock, thrower, (InvokeInstruction)ins);
            }
            if (!this.isCallToAdd((InvokeInstruction)ins, classContext.getConstantPoolGen())) continue;
            if (DEBUG) {
                System.out.println("Checking call to add...");
            }
            this.checkCallToAdd(classContext, method, basicBlock, thrower);
        }
    }

    private boolean isRecursiveCall(InvokeInstruction instruction, ClassContext classContext, Method method) {
        if (instruction.getOpcode() == 184 != method.isStatic()) {
            return false;
        }
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        return instruction.getClassName(cpg).equals(classContext.getJavaClass().getClassName()) && instruction.getName(cpg).equals(method.getName()) && instruction.getSignature(cpg).equals(method.getSignature());
    }

    private void checkRecursiveCall(ClassContext classContext, Method method, CFG cfg, BasicBlock basicBlock, InstructionHandle thrower, InvokeInstruction ins) throws DataflowAnalysisException, CFGBuilderException {
        if (DEBUG) {
            System.out.println("Checking recursive call in " + SignatureConverter.convertMethodSignature((JavaClass)classContext.getJavaClass(), (Method)method));
        }
        PostDominatorsAnalysis postDominators = classContext.getNonImplicitExceptionDominatorsAnalysis(method);
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        ValueNumberFrame vnaFrameAtEntry = (ValueNumberFrame)vnaDataflow.getStartFact(cfg.getEntry());
        BitSet entryPostDominators = postDominators.getAllDominatorsOf(cfg.getEntry());
        int numArgsToCheck = new SignatureParser(method.getSignature()).getNumParameters();
        if (!method.isStatic()) {
            ++numArgsToCheck;
        }
        boolean report = false;
        boolean bl = report = entryPostDominators.get(basicBlock.getId()) && this.targetMethodKnownExactly(classContext, method, basicBlock, ins);
        if (!report) {
            boolean bl2 = report = this.allParamsPassedAsArgs(classContext, vnaDataflow, vnaFrameAtEntry, numArgsToCheck, basicBlock, ins) && !this.checkedStateHasBeenModified(classContext, method, basicBlock);
        }
        if (report) {
            JavaClass javaClass = classContext.getJavaClass();
            String sourceFile = javaClass.getSourceFileName();
            BugInstance warning = new BugInstance("IL_INFINITE_RECURSIVE_LOOP", 1).addClassAndMethod(javaClass, method).addSourceLine(classContext.getMethodGen(method), sourceFile, thrower);
            this.bugReporter.reportBug(warning);
        }
    }

    private boolean targetMethodKnownExactly(ClassContext classContext, Method method, BasicBlock basicBlock, InvokeInstruction ins) throws DataflowAnalysisException, CFGBuilderException {
        int receiverStackSlot;
        ValueNumberFrame frameAtCall;
        ValueNumber callee;
        if (ins.getOpcode() == 184 || ins.getOpcode() == 183) {
            return true;
        }
        if (method.isPrivate()) {
            return true;
        }
        if (method.isFinal() || classContext.getJavaClass().isFinal()) {
            return true;
        }
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        ValueNumber caller = ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getThisValue();
        if (caller.equals(callee = (ValueNumber)(frameAtCall = (ValueNumberFrame)vnaDataflow.getStartFact(basicBlock)).getInstance((Instruction)ins, classContext.getConstantPoolGen()))) {
            return true;
        }
        TypeFrame typeFrame = (TypeFrame)classContext.getTypeDataflow(method).getStartFact(basicBlock);
        if (!typeFrame.isExact(receiverStackSlot = typeFrame.getInstanceSlot((Instruction)ins, classContext.getConstantPoolGen()))) {
            return false;
        }
        Type receiverType = (Type)typeFrame.getValue(receiverStackSlot);
        if (!(receiverType instanceof ObjectType)) {
            return false;
        }
        return ((ObjectType)receiverType).getClassName().equals(classContext.getJavaClass().getClassName());
    }

    private boolean allParamsPassedAsArgs(ClassContext classContext, ValueNumberDataflow vnaDataflow, ValueNumberFrame vnaFrameAtEntry, int numArgsToCheck, BasicBlock basicBlock, InvokeInstruction ins) throws DataflowAnalysisException {
        boolean allParamsPassedAsArgs = false;
        ValueNumberFrame vnaFrame = (ValueNumberFrame)vnaDataflow.getStartFact(basicBlock);
        if (vnaFrame.isValid() && vnaFrame.getStackDepth() >= numArgsToCheck) {
            allParamsPassedAsArgs = true;
            for (int arg = 0; arg < numArgsToCheck; ++arg) {
                ValueNumber paramVal = (ValueNumber)vnaFrameAtEntry.getValue(arg);
                ValueNumber argVal = (ValueNumber)vnaFrame.getOperand((StackConsumer)ins, classContext.getConstantPoolGen(), arg);
                if (DEBUG) {
                    System.out.println("param=" + paramVal.getNumber() + ", arg=" + argVal.getNumber());
                }
                if (paramVal.equals(argVal)) continue;
                allParamsPassedAsArgs = false;
                break;
            }
        }
        return allParamsPassedAsArgs;
    }

    private boolean checkedStateHasBeenModified(ClassContext classContext, Method method, BasicBlock basicBlock) throws CFGBuilderException, DataflowAnalysisException {
        LoadDataflow loadDataflow = classContext.getLoadDataflow(method);
        FieldSet loadSet = (FieldSet)loadDataflow.getStartFact(basicBlock);
        StoreDataflow storeDataflow = classContext.getStoreDataflow(method);
        FieldSet storeSet = (FieldSet)storeDataflow.getStartFact(basicBlock);
        if (DEBUG) {
            System.out.println("Checking state: loads=" + loadSet + ", stores=" + storeSet);
        }
        if (loadSet.isEmpty() || storeSet.isEmpty()) {
            return false;
        }
        if (loadSet.isBottom() || storeSet.isBottom()) {
            return true;
        }
        if (loadSet.isTop() || storeSet.isTop()) {
            return true;
        }
        return loadSet.isIntersectionNonEmpty(storeSet);
    }

    private boolean isCallToAdd(InvokeInstruction ins, ConstantPoolGen cpg) {
        return ins.getOpcode() != 184 && ins.getName(cpg).equals("add") && ins.getSignature(cpg).equals("(Ljava/lang/Object;)Z");
    }

    private void checkCallToAdd(ClassContext classContext, Method method, BasicBlock basicBlock, InstructionHandle thrower) throws DataflowAnalysisException, CFGBuilderException {
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        ValueNumberFrame vnaFrame = (ValueNumberFrame)vnaDataflow.getStartFact(basicBlock);
        if (vnaFrame.isValid() && vnaFrame.getStackDepth() >= 2) {
            ValueNumber top = (ValueNumber)vnaFrame.getStackValue(0);
            ValueNumber next = (ValueNumber)vnaFrame.getStackValue(1);
            if (DEBUG) {
                System.out.println("top=" + top.getNumber() + ", next=" + next.getNumber());
            }
            if (top.equals(next)) {
                JavaClass javaClass = classContext.getJavaClass();
                String sourceFile = javaClass.getSourceFileName();
                BugInstance warning = new BugInstance("IL_CONTAINER_ADDED_TO_ITSELF", 2).addClassAndMethod(javaClass, method).addSourceLine(classContext.getMethodGen(method), sourceFile, thrower);
                this.bugReporter.reportBug(warning);
            }
        }
    }

    public void report() {
    }
}

