/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InstantiateStaticClass
extends BytecodeScanningDetector
implements Constants2 {
    private BugReporter bugReporter;
    Map<String, Boolean> isStaticClass = new HashMap<String, Boolean>();

    public InstantiateStaticClass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        try {
            if (seen == 183 && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("()V")) {
                String clsName = this.getClassConstantOperand();
                if (clsName.equals("java/lang/Object")) {
                    return;
                }
                if (this.getMethodName().equals("<init>") && this.getPC() == 1) {
                    return;
                }
                if (this.getMethodName().equals("<clinit>") && this.getClassName().equals(clsName)) {
                    return;
                }
                Boolean b = this.isStaticClass.get(clsName);
                if (b == null) {
                    b = this.isStaticOnlyClass(clsName);
                    this.isStaticClass.put(clsName, b);
                }
                if (b.booleanValue()) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "ISC_INSTANTIATE_STATIC_CLASS", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    private boolean isStaticOnlyClass(String clsName) throws ClassNotFoundException {
        JavaClass cls = Repository.lookupClass((String)(clsName = clsName.replace('/', '.')));
        if (cls.getInterfaceNames().length > 0) {
            return false;
        }
        String superClassName = cls.getSuperclassName();
        if (!superClassName.equals("java.lang.Object")) {
            return false;
        }
        Method[] methods = cls.getMethods();
        int staticCount = 0;
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.isStatic()) {
                ++staticCount;
                continue;
            }
            if (m.getName().equals("<init>")) {
                if (!m.getSignature().equals("()V")) {
                    return false;
                }
                Code c = m.getCode();
                if (c.getCode().length <= 5) continue;
                return false;
            }
            return false;
        }
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (f.isStatic()) {
                ++staticCount;
                continue;
            }
            if (f.isPrivate()) continue;
            return false;
        }
        return staticCount != 0;
    }
}

