/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class LoadOfKnownNullValue
implements Detector {
    private BugReporter bugReporter;

    public LoadOfKnownNullValue(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList = classContext.getJavaClass().getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        IsNullValueDataflow nullValueDataflow = classContext.getIsNullValueDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            int index;
            IsNullValue v;
            Location location = (Location)i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof ALOAD)) continue;
            ALOAD load = (ALOAD)ins;
            IsNullValueFrame frame = nullValueDataflow.getFactAtLocation(location);
            if (!frame.isValid() || !(v = (IsNullValue)frame.getValue(index = load.getIndex())).isDefinitelyNull()) continue;
            Instruction next = handle.getNext().getInstruction();
            InstructionHandle prevHandle = handle.getPrev();
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
            SourceLineAnnotation prevSourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((MethodGen)methodGen, (String)sourceFile, (InstructionHandle)prevHandle);
            if (next instanceof ARETURN || sourceLineAnnotation.getStartLine() > prevSourceLineAnnotation.getEndLine()) continue;
            int priority = 2;
            if (!v.isChecked()) {
                ++priority;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NP_LOAD_OF_KNOWN_NULL_VALUE", priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(sourceLineAnnotation));
        }
    }

    public void report() {
    }
}

