/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.AnalysisLocal;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class MethodReturnCheck
extends BytecodeScanningDetector {
    private static boolean DEBUG = Boolean.getBoolean("mrc.debug");
    private static final boolean CHECK_ALL = Boolean.getBoolean("mrc.checkall");
    private static final int SCAN = 0;
    private static final int SAW_INVOKE = 1;
    private static final BitSet INVOKE_OPCODE_SET = new BitSet();
    private static final String ANY;
    private static final String[][] STANDARD_POLICY_DATABASE;
    private static final String[][] JDK15_POLICY_DATABASE;
    static AnalysisLocal<PolicyDatabase> policyDatabaseLocal;
    private BugReporter bugReporter;
    private ClassContext classContext;
    private Method method;
    private int state;
    private int callPC;
    private String className;
    private String methodName;
    private String signature;

    static PolicyDatabase getDatabase() {
        PolicyDatabase database = (PolicyDatabase)policyDatabaseLocal.get();
        if (database == null) {
            database = new PolicyDatabase();
            for (int i = 0; i < STANDARD_POLICY_DATABASE.length; ++i) {
                String[] tuple = STANDARD_POLICY_DATABASE[i];
                database.add(new PolicyDatabaseEntry(tuple[0], tuple[1], tuple[2]));
            }
            policyDatabaseLocal.set((Object)database);
        }
        return database;
    }

    public MethodReturnCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        super.visitClassContext(classContext);
        this.classContext = null;
    }

    public void visit(Method method) {
        this.method = method;
    }

    public void visitCode(Code code) {
        if (!this.prescreen()) {
            return;
        }
        if (DEBUG) {
            System.out.println("Visiting " + this.method);
        }
        super.visitCode(code);
    }

    private boolean prescreen() {
        BitSet bytecodeSet = this.classContext.getBytecodeSet(this.method);
        if (!bytecodeSet.get(87) && !bytecodeSet.get(88)) {
            return false;
        }
        return bytecodeSet.get(185) || bytecodeSet.get(183) || bytecodeSet.get(184) || bytecodeSet.get(182);
    }

    public void sawOpcode(int seen) {
        boolean redo;
        do {
            redo = false;
            switch (this.state) {
                case 0: {
                    if (!INVOKE_OPCODE_SET.get(seen)) break;
                    this.callPC = this.getPC();
                    this.className = this.getDottedClassConstantOperand();
                    this.methodName = this.getNameConstantOperand();
                    this.signature = this.getSigConstantOperand();
                    if (!this.requiresReturnValueCheck()) break;
                    if (DEBUG) {
                        System.out.println("Saw " + this.className + "." + this.methodName + ":" + this.signature + " @" + this.callPC);
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (this.isPop(seen)) {
                        int popPC = this.getPC();
                        if (DEBUG) {
                            System.out.println("Saw POP @" + popPC);
                        }
                        BugInstance warning = new BugInstance((Detector)this, "RV_RETURN_VALUE_IGNORED", 2).addClassAndMethod((PreorderVisitor)this).addMethod(this.className, this.methodName, this.signature).describe("METHOD_CALLED").addSourceLine((PreorderVisitor)this, this.callPC);
                        this.bugReporter.reportBug(warning);
                    } else {
                        redo = true;
                    }
                    this.state = 0;
                    break;
                }
            }
        } while (redo);
    }

    private boolean isPop(int seen) {
        return seen == 87 || seen == 88;
    }

    private boolean requiresReturnValueCheck() {
        if (DEBUG) {
            System.out.println("Trying: " + this.className + "." + this.methodName + ":" + this.signature);
        }
        try {
            return MethodReturnCheck.getDatabase().match(this.className, this.methodName, this.signature);
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return false;
        }
    }

    static {
        INVOKE_OPCODE_SET.set(185);
        INVOKE_OPCODE_SET.set(183);
        INVOKE_OPCODE_SET.set(184);
        INVOKE_OPCODE_SET.set(182);
        ANY = null;
        STANDARD_POLICY_DATABASE = new String[][]{{ANY, "equals", "(Ljava/lang/Object;)Z"}, {"java.lang.String", ANY, "*)Ljava/lang/String;"}, {"java.lang.StringBuffer", "toString", "*)Ljava/lang/String;"}, {"java.lang.Thread", "<init>", ANY}, {"java.lang.Throwable", "<init>", ANY}, {"java.security.MessageDigest", "digest", "([B)[B"}, {"java.sql.Connection", ANY, ANY}, {"java.net.InetAddress", ANY, ANY}, {"java.math.BigDecimal", ANY, ANY}, {"java.math.BigInteger", ANY, ANY}, {"java.util.Enumeration", "hasMoreElements", "()Z"}, {"java.util.Iterator", "hasNext", "()Z"}, {"java.io.File", "createNewFile", "()Z"}};
        JDK15_POLICY_DATABASE = new String[][]{{"java.util.concurrent.locks.ReadWriteLock", "readLock", "()Ljava/util/concurrent/locks/Lock;"}, {"java.util.concurrent.locks.ReadWriteLock", "writeLock", "()Ljava/util/concurrent/locks/Lock;"}, {"java.util.concurrent.locks.Condition", "await", "(JLjava/util/concurrent/TimeUnit;)Z"}, {"java.util.concurrent.locks.Condition", "awaitUtil", "(Ljava/util/Date;)Z"}, {"java.util.concurrent.locks.Condition", "awaitNanos", "(J)Z"}, {"java.util.concurrent.Semaphore", "tryAcquire", "(JLjava/util/concurrent/TimeUnit;)Z"}, {"java.util.concurrent.Semaphore", "tryAcquire", "()Z"}, {"java.util.concurrent.locks.Lock", "tryLock", "(JLjava/util/concurrent/TimeUnit;)Z"}, {"java.util.concurrent.locks.Lock", "newCondition", "()Ljava/util/concurrent/locks/Condition;"}, {"java.util.concurrent.locks.Lock", "tryLock", "()Z"}, {"java.util.Queue", "offer", "(Ljava/lang/Object;)Z"}, {"java.util.concurrent.BlockingQueue", "offer", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z"}, {"java.util.concurrent.BlockingQueue", "poll", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"}, {"java.util.Queue", "poll", "()Ljava/lang/Object;"}};
        policyDatabaseLocal = new AnalysisLocal();
    }

    private static class PolicyDatabase {
        private List<PolicyDatabaseEntry> database = new ArrayList<PolicyDatabaseEntry>();

        public void add(PolicyDatabaseEntry entry) {
            this.database.add(entry);
        }

        public boolean match(String className, String methodName, String signature) throws ClassNotFoundException {
            Iterator<PolicyDatabaseEntry> i = this.database.iterator();
            while (i.hasNext()) {
                PolicyDatabaseEntry entry = i.next();
                if (!entry.match(className, methodName, signature)) continue;
                return true;
            }
            return false;
        }
    }

    private static class PolicyDatabaseEntry {
        private String className;
        private String methodName;
        private String signature;
        private Pattern methodPattern;
        private Pattern signaturePattern;

        public PolicyDatabaseEntry(String className, String methodName, String signature) {
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.methodPattern = this.createPattern(methodName);
            this.signaturePattern = this.createPattern(signature);
        }

        public boolean match(String className, String methodName, String signature) throws ClassNotFoundException {
            return this.matchClass(className) && this.matchElement(methodName, this.methodName, this.methodPattern) && this.matchElement(signature, this.signature, this.signaturePattern);
        }

        private boolean matchClass(String className) throws ClassNotFoundException {
            return this.className == null || Hierarchy.isSubtype((String)className, (String)this.className);
        }

        private boolean matchElement(String value, String expected, Pattern pattern) {
            if (expected == null) {
                return true;
            }
            if (pattern == null) {
                return value.equals(expected);
            }
            Matcher matcher = pattern.matcher(value);
            return matcher.matches();
        }

        private Pattern createPattern(String s) {
            if (s == null || s.indexOf(42) < 0) {
                return null;
            }
            StringBuffer regex = new StringBuffer();
            regex.append('^');
            while (s.length() > 0) {
                int star = s.indexOf(42);
                if (star < 0) {
                    this.appendLiteral(regex, s);
                    s = "";
                    continue;
                }
                this.appendLiteral(regex, s.substring(0, star));
                regex.append(".*");
                s = s.substring(star + 1);
            }
            regex.append('$');
            return Pattern.compile(regex.toString());
        }

        private void appendLiteral(StringBuffer regex, String s) {
            regex.append("\\Q");
            regex.append(s);
            regex.append("\\E");
        }
    }
}

