/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultithreadedInstanceAccess
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    private static final String STRUTS_ACTION_NAME = "org.apache.struts.action.Action";
    private static final String SERVLET_NAME = "javax.servlet.Servlet";
    private BugReporter bugReporter;
    private Set<JavaClass> mtClasses;
    private String mtClassName;
    private int monitorCount;
    private Set<String> alreadyReported;

    public MultithreadedInstanceAccess(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private Set<JavaClass> getMtClasses() {
        if (this.mtClasses != null) {
            return this.mtClasses;
        }
        this.mtClasses = new HashSet<JavaClass>();
        try {
            this.mtClasses.add(Repository.lookupClass((String)STRUTS_ACTION_NAME));
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            this.mtClasses.add(Repository.lookupClass((String)SERVLET_NAME));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.mtClasses;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            String superClsName = cls.getSuperclassName();
            if ("java.lang.Object".equals(superClsName)) {
                return;
            }
            if (STRUTS_ACTION_NAME.equals(superClsName)) {
                this.mtClassName = STRUTS_ACTION_NAME;
                super.visitClassContext(classContext);
            } else if (SERVLET_NAME.equals(superClsName)) {
                this.mtClassName = SERVLET_NAME;
                super.visitClassContext(classContext);
            } else {
                for (JavaClass mtClass : this.getMtClasses()) {
                    if (!cls.implementationOf(mtClass) && !cls.instanceOf(mtClass)) continue;
                    this.mtClassName = mtClass.getClassName();
                    super.visitClassContext(classContext);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void visitMethod(Method obj) {
        this.monitorCount = 0;
        this.alreadyReported = new HashSet<String>();
    }

    public void sawField() {
        ConstantFieldref fieldRef;
        String className;
        if (this.monitorCount > 0) {
            return;
        }
        Constant c = this.getConstantRefOperand();
        if (c instanceof ConstantFieldref && (className = (fieldRef = (ConstantFieldref)c).getClass(this.getConstantPool()).replace('.', '/')).equals(this.getClassName())) {
            ConstantPool cp = this.getConstantPool();
            int nameAndTypeIdx = fieldRef.getNameAndTypeIndex();
            ConstantNameAndType ntc = (ConstantNameAndType)cp.getConstant(nameAndTypeIdx);
            int nameIdx = ntc.getNameIndex();
            Field[] flds = this.getClassContext().getJavaClass().getFields();
            for (int i = 0; i < flds.length; ++i) {
                if (flds[i].getNameIndex() != nameIdx) continue;
                if (flds[i].isStatic()) break;
                ConstantUtf8 nameCons = (ConstantUtf8)cp.getConstant(nameIdx);
                ConstantUtf8 typeCons = (ConstantUtf8)cp.getConstant(ntc.getSignatureIndex());
                if (this.alreadyReported.contains(nameCons.getBytes())) {
                    return;
                }
                this.alreadyReported.add(nameCons.getBytes());
                this.bugReporter.reportBug(new BugInstance((Detector)this, STRUTS_ACTION_NAME.equals(this.mtClassName) ? "MTIA_SUSPECT_STRUTS_INSTANCE_FIELD" : "MTIA_SUSPECT_SERVLET_INSTANCE_FIELD", 3).addClass((PreorderVisitor)this).addSourceLine((DismantleBytecode)this).addField(new FieldAnnotation(this.getClassName(), nameCons.getBytes(), typeCons.getBytes(), false)));
                break;
            }
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 194) {
            ++this.monitorCount;
        } else if (seen == 195) {
            --this.monitorCount;
        }
    }
}

