/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MutableLock
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    Set<String> setFields = new HashSet<String>();
    boolean thisOnTOS = false;
    private BugReporter bugReporter;

    public MutableLock(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.setFields.clear();
        this.thisOnTOS = false;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 42: {
                this.thisOnTOS = true;
                return;
            }
            case 195: {
                this.setFields.clear();
                break;
            }
            case 181: {
                if (!this.getClassConstantOperand().equals(this.getClassName())) break;
                this.setFields.add(this.getNameConstantOperand());
                break;
            }
            case 180: {
                if (!this.thisOnTOS || !this.getClassConstantOperand().equals(this.getClassName()) || !this.setFields.contains(this.getNameConstantOperand()) || this.asUnsignedByte(this.codeBytes[this.getPC() + 3]) != 89 || this.asUnsignedByte(this.codeBytes[this.getPC() + 5]) != 194) break;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "ML_SYNC_ON_UPDATED_FIELD", 2).addClassAndMethod((PreorderVisitor)this).addReferencedField((DismantleBytecode)this).addSourceLine((PreorderVisitor)this, this.getPC() + 5));
                break;
            }
        }
        this.thisOnTOS = false;
    }
}

