/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class PublicSemaphores
extends BytecodeScanningDetector
implements StatelessDetector,
Constants2 {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_ALOAD_0 = 1;
    private BugReporter bugReporter;
    private int state;
    private boolean alreadyReported;

    public PublicSemaphores(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        if (!cls.isPublic() || cls.getClassName().indexOf("$") >= 0) {
            return;
        }
        this.alreadyReported = false;
        super.visitClassContext(classContext);
    }

    public void visit(Code obj) {
        Method m = this.getMethod();
        if (m.isStatic() || this.alreadyReported) {
            return;
        }
        this.state = 0;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (this.alreadyReported) {
            return;
        }
        switch (this.state) {
            case 0: {
                if (seen != 42) break;
                this.state = 1;
                break;
            }
            case 1: {
                String methodName;
                if (seen == 182 && this.getClassConstantOperand().equals("java/lang/Object") && ("wait".equals(methodName = this.getNameConstantOperand()) || "notify".equals(methodName) || "notifyAll".equals(methodName))) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "PS_PUBLIC_SEMAPHORES", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
                    this.alreadyReported = true;
                }
                this.state = 0;
            }
        }
    }
}

