/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Method;

public class ReadReturnShouldBeChecked
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    boolean sawRead = false;
    boolean sawSkip = false;
    int sawAvailable = 0;
    boolean wasBufferedInputStream = false;
    private BugReporter bugReporter;
    private int readPC;
    private int skipPC;
    private String lastCallClass = null;
    private String lastCallMethod = null;
    private String lastCallSig = null;

    public ReadReturnShouldBeChecked(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Method obj) {
        this.sawAvailable = 0;
        this.sawRead = false;
        this.sawSkip = false;
    }

    public void sawOpcode(int seen) {
        boolean isInputStream = false;
        boolean isBufferedInputStream = false;
        if (seen == 182 || seen == 185) {
            this.lastCallClass = this.getDottedClassConstantOperand();
            this.lastCallMethod = this.getNameConstantOperand();
            this.lastCallSig = this.getDottedSigConstantOperand();
            if (!this.lastCallClass.startsWith("[")) {
                try {
                    isInputStream = (Repository.instanceOf((String)this.lastCallClass, (String)"java.io.InputStream") || Repository.implementationOf((String)this.lastCallClass, (String)"java.io.DataInput") || Repository.instanceOf((String)this.lastCallClass, (String)"java.io.Reader")) && !Repository.instanceOf((String)this.lastCallClass, (String)"java.io.ByteArrayInputStream");
                    isBufferedInputStream = Repository.instanceOf((String)this.getDottedClassConstantOperand(), (String)"java.io.BufferedInputStream");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        if ((seen == 182 || seen == 185) && (this.getNameConstantOperand().equals("available") && this.getSigConstantOperand().equals("()I") || this.getNameConstantOperand().startsWith("get") && this.getNameConstantOperand().endsWith("Length") && this.getSigConstantOperand().equals("()I") || this.getClassConstantOperand().equals("java/io/File") && this.getNameConstantOperand().equals("length") && this.getSigConstantOperand().equals("()J"))) {
            this.sawAvailable = 70;
            return;
        }
        --this.sawAvailable;
        if ((seen == 182 || seen == 185) && isInputStream && this.getNameConstantOperand().equals("read") && (this.getSigConstantOperand().equals("([B)I") || this.getSigConstantOperand().equals("([BII)I") || this.getSigConstantOperand().equals("([C)I") || this.getSigConstantOperand().equals("([CII)I")) && this.sawAvailable <= 0) {
            this.sawRead = true;
            this.readPC = this.getPC();
            return;
        }
        if ((seen == 182 || seen == 185) && isInputStream && this.getNameConstantOperand().equals("skip") && this.getSigConstantOperand().equals("(J)J") && (this.sawAvailable <= 0 || isBufferedInputStream)) {
            this.wasBufferedInputStream = isBufferedInputStream;
            this.sawSkip = true;
            this.skipPC = this.getPC();
            return;
        }
        if (seen == 87 || seen == 88) {
            if (this.sawRead) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "RR_NOT_CHECKED", 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod(this.lastCallClass, this.lastCallMethod, this.lastCallSig).addSourceLine((PreorderVisitor)this, this.readPC));
            } else if (this.sawSkip) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SR_NOT_CHECKED", this.wasBufferedInputStream ? 1 : 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod(this.lastCallClass, this.lastCallMethod, this.lastCallSig).addSourceLine((PreorderVisitor)this, this.skipPC));
            }
        }
        this.sawRead = false;
        this.sawSkip = false;
    }
}

