/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class RedundantInterfaces
extends PreorderVisitor
implements Detector,
Constants2,
StatelessDetector {
    private BugReporter bugReporter;

    public RedundantInterfaces(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass obj = classContext.getJavaClass();
        String superClassName = obj.getSuperclassName();
        if (superClassName.equals("java.lang.Object")) {
            return;
        }
        String[] interfaceNames = obj.getInterfaceNames();
        if (interfaceNames == null || interfaceNames.length == 0) {
            return;
        }
        try {
            JavaClass superObj = obj.getSuperClass();
            TreeSet<String> redundantInfNames = new TreeSet<String>();
            for (int i = 0; i < interfaceNames.length; ++i) {
                JavaClass inf = Repository.lookupClass((String)interfaceNames[i]);
                if (!superObj.instanceOf(inf)) continue;
                redundantInfNames.add(inf.getClassName());
            }
            if (redundantInfNames.size() > 0) {
                BugInstance bug = new BugInstance((Detector)this, "RI_REDUNDANT_INTERFACES", 3).addClass(obj);
                Iterator it = redundantInfNames.iterator();
                while (it.hasNext()) {
                    bug.addClass((String)it.next()).describe("INTERFACE_TYPE");
                }
                this.bugReporter.reportBug(bug);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void report() {
    }
}

