/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.InstructionHandle;

public class RuntimeExceptionCapture
extends BytecodeScanningDetector
implements Detector,
StatelessDetector {
    private static final boolean DEBUG = Boolean.getBoolean("rec.debug");
    private BugReporter bugReporter;
    private Method method;
    private OpcodeStack stack = new OpcodeStack();
    private List<CaughtException> catchList;
    private List<ThrownException> throwList;

    public RuntimeExceptionCapture(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitMethod(Method method) {
        this.method = method;
        if (DEBUG) {
            System.out.println("RuntimeExceptionCapture visiting " + method);
        }
        super.visitMethod(method);
    }

    public void visitCode(Code obj) {
        this.catchList = new ArrayList<CaughtException>();
        this.throwList = new ArrayList<ThrownException>();
        this.stack.resetForMethodEntry((PreorderVisitor)this);
        super.visitCode(obj);
        Iterator<CaughtException> iterator = this.catchList.iterator();
        while (iterator.hasNext()) {
            CaughtException caughtException = iterator.next();
            HashSet<String> thrownSet = new HashSet<String>();
            Iterator<ThrownException> iterator1 = this.throwList.iterator();
            while (iterator1.hasNext()) {
                ThrownException thrownException = iterator1.next();
                if (thrownException.offset < caughtException.startOffset || thrownException.offset >= caughtException.endOffset) continue;
                thrownSet.add(thrownException.exceptionClass);
                if (!thrownException.exceptionClass.equals(caughtException.exceptionClass)) continue;
                caughtException.seen = true;
            }
            int catchClauses = 0;
            if (!caughtException.exceptionClass.equals("java.lang.Exception") || caughtException.seen) continue;
            boolean rteCaught = false;
            Iterator<CaughtException> iterator12 = this.catchList.iterator();
            while (iterator12.hasNext()) {
                CaughtException otherException = iterator12.next();
                if (otherException.startOffset != caughtException.startOffset || otherException.endOffset != caughtException.endOffset) continue;
                ++catchClauses;
                if (!otherException.exceptionClass.equals("java.lang.RuntimeException")) continue;
                rteCaught = true;
            }
            int range = caughtException.endOffset - caughtException.startOffset;
            if (rteCaught) continue;
            int priority = 4;
            if (range > 300) {
                --priority;
            } else if (range < 30) {
                ++priority;
            }
            if (catchClauses > 1) {
                ++priority;
            }
            if (thrownSet.size() > 1) {
                --priority;
            }
            if (caughtException.dead) {
                --priority;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "REC_CATCH_EXCEPTION", priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((PreorderVisitor)this, caughtException.sourcePC));
        }
    }

    public void visit(CodeException obj) {
        super.visit(obj);
        int type = obj.getCatchType();
        if (type == 0) {
            return;
        }
        String name = this.getConstantPool().constantToString(this.getConstantPool().getConstant(type));
        CaughtException caughtException = new CaughtException(name, obj.getStartPC(), obj.getEndPC(), obj.getHandlerPC());
        this.catchList.add(caughtException);
        try {
            LiveLocalStoreDataflow dataflow = this.getClassContext().getLiveLocalStoreDataflow(this.method);
            CFG cfg = this.getClassContext().getCFG(this.method);
            Collection blockList = cfg.getBlocksContainingInstructionWithOffset(obj.getHandlerPC());
            Iterator i = blockList.iterator();
            while (i.hasNext()) {
                BasicBlock block = (BasicBlock)i.next();
                InstructionHandle first = block.getFirstInstruction();
                if (first == null || first.getPosition() != obj.getHandlerPC() || !(first.getInstruction() instanceof ASTORE)) continue;
                ASTORE astore = (ASTORE)first.getInstruction();
                BitSet liveStoreSet = dataflow.getFactAtLocation(new Location(first, block));
                if (liveStoreSet.get(astore.getIndex())) continue;
                if (DEBUG) {
                    System.out.println("Dead exception store at " + first);
                }
                caughtException.dead = true;
                break;
            }
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("Error checking for dead exception store", (Throwable)e);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Error checking for dead exception store", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            switch (seen) {
                case 191: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    String signature = item.getSignature();
                    if (signature == null) return;
                    if (signature.length() <= 0) return;
                    signature = signature.startsWith("L") ? SignatureConverter.convert((String)signature) : signature.replace('/', '.');
                    this.throwList.add(new ThrownException(signature, this.getPC()));
                    return;
                }
                case 182: 
                case 183: 
                case 184: {
                    String className = this.getDottedClassConstantOperand();
                    try {
                        if (className.startsWith("[")) return;
                        JavaClass clazz = Repository.lookupClass((String)className);
                        Method[] methods = clazz.getMethods();
                        int i = 0;
                        while (i < methods.length) {
                            Method method = methods[i];
                            if (method.getName().equals(this.getNameConstantOperand()) && method.getSignature().equals(this.getSigConstantOperand())) {
                                ExceptionTable et = method.getExceptionTable();
                                if (et == null) return;
                                String[] names = et.getExceptionNames();
                                int j = 0;
                                while (j < names.length) {
                                    this.throwList.add(new ThrownException(names[j], this.getPC()));
                                    ++j;
                                }
                                break block9;
                                return;
                            }
                            ++i;
                        }
                        return;
                    }
                    catch (ClassNotFoundException e) {
                        this.bugReporter.reportMissingClass(e);
                        return;
                    }
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static class ThrownException {
        public String exceptionClass;
        public int offset;

        public ThrownException(String exceptionClass, int offset) {
            this.exceptionClass = exceptionClass;
            this.offset = offset;
        }
    }

    private static class CaughtException {
        public String exceptionClass;
        public int startOffset;
        public int endOffset;
        public int sourcePC;
        public boolean seen = false;
        public boolean dead = false;

        public CaughtException(String exceptionClass, int startOffset, int endOffset, int sourcePC) {
            this.exceptionClass = exceptionClass;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.sourcePC = sourcePC;
        }
    }
}

