/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ResourceCollection;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.detect.FindOpenStream;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamEquivalenceClass;
import edu.umd.cs.findbugs.detect.StreamEscape;
import edu.umd.cs.findbugs.detect.StreamFactory;
import edu.umd.cs.findbugs.detect.StreamFrameModelingVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamResourceTracker
implements ResourceTracker<Stream> {
    private StreamFactory[] streamFactoryList;
    private RepositoryLookupFailureCallback lookupFailureCallback;
    private ResourceCollection<Stream> resourceCollection;
    private Map<Location, Stream> streamOpenLocationMap;
    private HashSet<Stream> uninterestingStreamEscapeSet;
    private TreeSet<StreamEscape> streamEscapeSet;
    private Map<Stream, StreamEquivalenceClass> streamEquivalenceMap;

    public StreamResourceTracker(StreamFactory[] streamFactoryList, RepositoryLookupFailureCallback lookupFailureCallback) {
        this.streamFactoryList = streamFactoryList;
        this.lookupFailureCallback = lookupFailureCallback;
        this.streamOpenLocationMap = new HashMap<Location, Stream>();
        this.uninterestingStreamEscapeSet = new HashSet();
        this.streamEscapeSet = new TreeSet();
        this.streamEquivalenceMap = new HashMap<Stream, StreamEquivalenceClass>();
    }

    public void setResourceCollection(ResourceCollection<Stream> resourceCollection) {
        this.resourceCollection = resourceCollection;
    }

    public void addStreamEscape(Stream source, Location target) {
        StreamEscape streamEscape = new StreamEscape(source, target);
        this.streamEscapeSet.add(streamEscape);
        if (FindOpenStream.DEBUG) {
            System.out.println(new StringBuffer().append("Adding potential stream escape ").append(streamEscape).toString());
        }
    }

    public void markTransitiveUninterestingStreamEscapes() {
        Iterator i = this.streamEscapeSet.iterator();
        while (i.hasNext()) {
            StreamEscape streamEscape = i.next();
            if (this.isStreamOpenLocation(streamEscape.target)) continue;
            if (FindOpenStream.DEBUG) {
                System.out.println(new StringBuffer().append("Eliminating false stream escape ").append(streamEscape).toString());
            }
            i.remove();
        }
        i = this.resourceCollection.resourceIterator();
        while (i.hasNext()) {
            Stream stream = (Stream)i.next();
            StreamEquivalenceClass equivalenceClass = new StreamEquivalenceClass();
            equivalenceClass.addMember(stream);
            this.streamEquivalenceMap.put(stream, equivalenceClass);
        }
        HashSet<Stream> orig = new HashSet<Stream>();
        do {
            orig.clear();
            orig.addAll(this.uninterestingStreamEscapeSet);
            for (StreamEscape streamEscape : this.streamEscapeSet) {
                StreamEquivalenceClass targetClass;
                Stream target;
                if (!this.isUninterestingStreamEscape(streamEscape.source)) continue;
                if (FindOpenStream.DEBUG) {
                    System.out.println(new StringBuffer().append("Propagating stream escape ").append(streamEscape).toString());
                }
                if ((target = this.streamOpenLocationMap.get(streamEscape.target)) == null) {
                    throw new IllegalStateException();
                }
                this.uninterestingStreamEscapeSet.add(target);
                StreamEquivalenceClass sourceClass = this.streamEquivalenceMap.get(streamEscape.source);
                if (sourceClass == (targetClass = this.streamEquivalenceMap.get(target))) continue;
                sourceClass.addAll(targetClass);
                Iterator<Stream> j = targetClass.memberIterator();
                while (j.hasNext()) {
                    Stream stream = j.next();
                    this.streamEquivalenceMap.put(stream, sourceClass);
                }
            }
        } while (!((Object)orig).equals(this.uninterestingStreamEscapeSet));
    }

    public boolean isUninterestingStreamEscape(Stream stream) {
        return this.uninterestingStreamEscapeSet.contains(stream);
    }

    public void addStreamOpenLocation(Location streamOpenLocation, Stream stream) {
        if (FindOpenStream.DEBUG) {
            System.out.println(new StringBuffer().append("Stream open location at ").append(streamOpenLocation).toString());
        }
        this.streamOpenLocationMap.put(streamOpenLocation, stream);
        if (stream.isUninteresting()) {
            this.uninterestingStreamEscapeSet.add(stream);
        }
    }

    public StreamEquivalenceClass getStreamEquivalenceClass(Stream stream) {
        return this.streamEquivalenceMap.get(stream);
    }

    private boolean isStreamOpenLocation(Location location) {
        return this.streamOpenLocationMap.get(location) != null;
    }

    public Stream isResourceCreation(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) {
        if (this.resourceCollection != null) {
            return (Stream)this.resourceCollection.getCreatedResource(new Location(handle, basicBlock));
        }
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof TypedInstruction)) {
            return null;
        }
        Type type = ((TypedInstruction)ins).getType(cpg);
        if (!(type instanceof ObjectType)) {
            return null;
        }
        Location location = new Location(handle, basicBlock);
        for (int i = 0; i < this.streamFactoryList.length; ++i) {
            Stream stream = this.streamFactoryList[i].createStream(location, (ObjectType)type, cpg, this.lookupFailureCallback);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public boolean isResourceOpen(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Stream resource, ResourceValueFrame frame) {
        return resource.isStreamOpen(basicBlock, handle, cpg, frame);
    }

    public boolean isResourceClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Stream resource, ResourceValueFrame frame) {
        return resource.isStreamClose(basicBlock, handle, cpg, frame, this.lookupFailureCallback);
    }

    public ResourceValueFrameModelingVisitor createVisitor(Stream resource, ConstantPoolGen cpg) {
        return new StreamFrameModelingVisitor(cpg, this, resource);
    }

    public boolean ignoreImplicitExceptions(Stream resource) {
        return resource.ignoreImplicitExceptions();
    }

    public boolean ignoreExceptionEdge(Edge edge, Stream resource, ConstantPoolGen cpg) {
        return false;
    }

    public boolean isParamInstance(Stream resource, int slot) {
        return resource.getInstanceParam() == slot;
    }

    public /* synthetic */ boolean isParamInstance(Object x0, int x1) {
        return this.isParamInstance((Stream)x0, x1);
    }

    public /* synthetic */ boolean ignoreExceptionEdge(Edge x0, Object x1, ConstantPoolGen x2) {
        return this.ignoreExceptionEdge(x0, (Stream)x1, x2);
    }

    public /* synthetic */ boolean ignoreImplicitExceptions(Object x0) {
        return this.ignoreImplicitExceptions((Stream)x0);
    }

    public /* synthetic */ ResourceValueFrameModelingVisitor createVisitor(Object x0, ConstantPoolGen x1) {
        return this.createVisitor((Stream)x0, x1);
    }

    public /* synthetic */ boolean isResourceClose(BasicBlock x0, InstructionHandle x1, ConstantPoolGen x2, Object x3, ResourceValueFrame x4) throws DataflowAnalysisException {
        return this.isResourceClose(x0, x1, x2, (Stream)x3, x4);
    }

    public /* synthetic */ Object isResourceCreation(BasicBlock x0, InstructionHandle x1, ConstantPoolGen x2) throws DataflowAnalysisException {
        return this.isResourceCreation(x0, x1, x2);
    }
}

