/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Method;

public class SuspiciousThreadInterrupted
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    public static final int SEEN_NOTHING = 0;
    public static final int SEEN_CURRENTTHREAD = 1;
    public static final int SEEN_POP_AFTER_CURRENTTHREAD = 2;
    public static final int SEEN_UNKNOWNCONTEXT_POP = 3;
    private BugReporter bugReporter;
    private BitSet localsWithCurrentThreadValue;
    private int state;

    public SuspiciousThreadInterrupted(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Method obj) {
        this.localsWithCurrentThreadValue = new BitSet();
        this.state = 0;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen == 184 && this.getClassConstantOperand().equals("java/lang/Thread") && this.getNameConstantOperand().equals("currentThread") && this.getSigConstantOperand().equals("()Ljava/lang/Thread;")) {
                    this.state = 1;
                    break;
                }
                if (seen == 25) {
                    if (!this.localsWithCurrentThreadValue.get(this.getRegisterOperand())) break;
                    this.state = 1;
                    break;
                }
                if (seen >= 42 && seen <= 45) {
                    if (!this.localsWithCurrentThreadValue.get(seen - 42)) break;
                    this.state = 1;
                    break;
                }
                if (seen != 87) break;
                this.state = 3;
                break;
            }
            case 1: {
                if (seen == 87) {
                    this.state = 2;
                    break;
                }
                if (seen == 58) {
                    this.localsWithCurrentThreadValue.set(this.getRegisterOperand());
                    this.state = 0;
                    break;
                }
                if (seen >= 75 && seen <= 78) {
                    this.localsWithCurrentThreadValue.set(seen - 75);
                    this.state = 0;
                    break;
                }
                this.state = 0;
                break;
            }
            default: {
                if (seen == 184 && this.getClassConstantOperand().equals("java/lang/Thread") && this.getNameConstantOperand().equals("interrupted") && this.getSigConstantOperand().equals("()Z")) {
                    if (this.state == 2) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "STI_INTERRUPTED_ON_CURRENTTHREAD", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
                    } else if (this.state == 3) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "STI_INTERRUPTED_ON_UNKNOWNTHREAD", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
                    }
                }
                this.state = 0;
            }
        }
    }
}

