/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SwitchHandler;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Visitor;

public class SwitchFallthrough
extends BytecodeScanningDetector
implements Constants2,
StatelessDetector {
    private static final boolean DEBUG = Boolean.getBoolean("switchFallthrough.debug");
    private static final boolean LOOK_IN_SOURCE_FOR_FALLTHRU_COMMENT = Boolean.getBoolean("findbugs.sf.comment");
    private SwitchHandler switchHdlr;
    private boolean reachable;
    private BugReporter bugReporter;
    private int lastPC;

    public SwitchFallthrough(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visit(Code obj) {
        this.reachable = false;
        this.lastPC = 0;
        this.switchHdlr = new SwitchHandler();
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (this.reachable && this.switchHdlr.isOnSwitchOffset((DismantleBytecode)this) && !this.hasFallThruComment(this.lastPC + 1, this.getPC() - 1)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SF_SWITCH_FALLTHROUGH", 2).addClassAndMethod((PreorderVisitor)this).addSourceLineRange((PreorderVisitor)this, this.lastPC, this.getPC()));
        }
        switch (seen) {
            case 170: 
            case 171: {
                this.reachable = false;
                this.switchHdlr.enterSwitch((DismantleBytecode)this);
                break;
            }
            case 167: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: 
            case 200: {
                this.reachable = false;
                break;
            }
            default: {
                this.reachable = true;
            }
        }
        this.lastPC = this.getPC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFallThruComment(int startPC, int endPC) {
        if (!LOOK_IN_SOURCE_FOR_FALLTHRU_COMMENT) return false;
        BufferedReader r = null;
        try {
            String line;
            int i;
            SourceLineAnnotation srcLine = SourceLineAnnotation.fromVisitedInstructionRange((PreorderVisitor)this, (int)this.lastPC, (int)this.getPC());
            SourceFinder sourceFinder = AnalysisContext.currentAnalysisContext().getSourceFinder();
            SourceFile sourceFile = sourceFinder.findSourceFile(srcLine.getPackageName(), srcLine.getSourceFile());
            int startLine = srcLine.getStartLine();
            int numLines = srcLine.getEndLine() - startLine - 1;
            if (numLines <= 0) {
                boolean bl = false;
                return bl;
            }
            r = new BufferedReader(new InputStreamReader(sourceFile.getInputStream()));
            for (i = 0; i < startLine; ++i) {
                line = r.readLine();
                if (line != null) continue;
                boolean bl = false;
                return bl;
            }
            i = 0;
            while (i < numLines) {
                line = r.readLine();
                if (line == null) {
                    boolean bl = false;
                    return bl;
                }
                if ((line = line.toLowerCase()).indexOf("fall") >= 0 || line.indexOf("nobreak") >= 0) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

