/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.text.NumberFormat;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class TestingGround
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean active = Boolean.getBoolean("findbugs.tg.active");
    private NumberFormat formatter = null;
    BugReporter bugReporter;
    OpcodeStack stack = new OpcodeStack();

    public TestingGround(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (active) {
            this.formatter = NumberFormat.getIntegerInstance();
            this.formatter.setMinimumIntegerDigits(4);
            this.formatter.setGroupingUsed(false);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
    }

    public void visit(Code obj) {
        if (active) {
            this.stack.resetForMethodEntry((PreorderVisitor)this);
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 184 && this.getNameConstantOperand().equals("forName") && this.getClassConstantOperand().equals("java/lang/Class") && this.getSigConstantOperand().equals("(Ljava/lang/String;)Ljava/lang/Class;")) {
            if (this.stack.getStackDepth() == 0) {
                System.out.println("empty stack");
            } else {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                Object constantValue = item.getConstant();
                if (constantValue != null && constantValue instanceof String) {
                    System.out.println("XXYYZ: " + this.getFullyQualifiedMethodName() + " Class.forName(" + constantValue + ")");
                } else {
                    System.out.println("XXYYZ: " + this.getFullyQualifiedMethodName() + " Class.forName(???)");
                }
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    private void printOpCode(int seen) {
        System.out.print("  TestingGround: [" + this.formatter.format(this.getPC()) + "]  " + OPCODE_NAMES[seen]);
        if (seen == 182 || seen == 183 || seen == 185 || seen == 184) {
            System.out.print("   " + this.getClassConstantOperand() + "." + this.getNameConstantOperand() + " " + this.getSigConstantOperand());
        } else if (seen == 18 || seen == 19 || seen == 20) {
            Constant c = this.getConstantRefOperand();
            if (c instanceof ConstantString) {
                System.out.print("   \"" + this.getStringConstantOperand() + "\"");
            } else if (c instanceof ConstantClass) {
                System.out.print("   " + this.getClassConstantOperand());
            } else {
                System.out.print("   " + c);
            }
        } else if (seen == 25 || seen == 58) {
            System.out.print("   " + this.getRegisterOperand());
        } else if (seen == 167 || seen == 200 || seen == 165 || seen == 166 || seen == 159 || seen == 162 || seen == 163 || seen == 164 || seen == 161 || seen == 160 || seen == 153 || seen == 156 || seen == 157 || seen == 158 || seen == 155 || seen == 154 || seen == 199 || seen == 198) {
            System.out.print("   " + this.getBranchTarget());
        } else if (seen == 187 || seen == 193) {
            System.out.print("   " + this.getClassConstantOperand());
        } else if (seen == 170 || seen == 171) {
            System.out.print("    [");
            int switchPC = this.getPC();
            int[] offsets = this.getSwitchOffsets();
            for (int i = 0; i < offsets.length; ++i) {
                System.out.print(switchPC + offsets[i] + ",");
            }
            System.out.print(switchPC + this.getDefaultSwitchOffset() + "]");
        }
        System.out.println();
    }
}

