/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class UnreadFields
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("unreadfields.debug");
    Map<FieldAnnotation, HashSet<ProgramPoint>> assumedNonNull = new HashMap<FieldAnnotation, HashSet<ProgramPoint>>();
    Set<FieldAnnotation> nullTested = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> declaredFields = new TreeSet<FieldAnnotation>();
    Set<FieldAnnotation> fieldsOfSerializableOrNativeClassed = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> staticFieldsReadInThisMethod = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> allMyFields = new TreeSet<FieldAnnotation>();
    Set<FieldAnnotation> myFields = new TreeSet<FieldAnnotation>();
    Set<FieldAnnotation> writtenFields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> writtenNonNullFields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> writtenInConstructorFields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> readFields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> constantFields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> finalFields = new HashSet<FieldAnnotation>();
    Set<String> needsOuterObjectInConstructor = new HashSet<String>();
    Set<String> superReadFields = new HashSet<String>();
    Set<String> superWrittenFields = new HashSet<String>();
    Set<String> innerClassCannotBeStatic = new HashSet<String>();
    boolean hasNativeMethods;
    boolean isSerializable;
    boolean sawSelfCallInConstructor;
    private BugReporter bugReporter;
    boolean publicOrProtectedConstructor;
    static final int doNotConsider = 5;
    int count_aload_1;
    private OpcodeStack opcodeStack = new OpcodeStack();
    private int previousOpcode;
    private int previousPreviousOpcode;
    boolean seenInvokeStatic;
    Pattern dontComplainAbout = Pattern.compile("class[$]");

    public UnreadFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        this.hasNativeMethods = false;
        this.sawSelfCallInConstructor = false;
        this.publicOrProtectedConstructor = false;
        this.isSerializable = false;
        if (this.getSuperclassName().indexOf("$") >= 0 || this.getSuperclassName().indexOf("+") >= 0) {
            this.innerClassCannotBeStatic.add(this.getDottedClassName());
            this.innerClassCannotBeStatic.add(this.getDottedSuperclassName());
        }
        String[] interface_names = obj.getInterfaceNames();
        for (int i = 0; i < interface_names.length; ++i) {
            if (interface_names[i].equals("java.io.Externalizable")) {
                this.isSerializable = true;
                continue;
            }
            if (!interface_names[i].equals("java.io.Serializable")) continue;
            this.isSerializable = true;
            break;
        }
        if (!this.isSerializable) {
            try {
                if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Externalizable")) {
                    this.isSerializable = true;
                }
                if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Serializable")) {
                    this.isSerializable = true;
                }
                if (Repository.instanceOf((JavaClass)obj, (String)"java.rmi.Remote")) {
                    this.isSerializable = true;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        super.visit(obj);
    }

    public void visitAfter(JavaClass obj) {
        this.declaredFields.addAll(this.myFields);
        if (this.hasNativeMethods || this.isSerializable) {
            this.fieldsOfSerializableOrNativeClassed.addAll(this.myFields);
        }
        if (this.sawSelfCallInConstructor) {
            this.writtenInConstructorFields.addAll(this.myFields);
        }
        this.myFields.clear();
        this.allMyFields.clear();
    }

    public void visit(Field obj) {
        super.visit(obj);
        FieldAnnotation f = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
        this.allMyFields.add(f);
        int flags = obj.getAccessFlags();
        if ((flags & 5) == 0 && !this.getFieldName().equals("serialVersionUID")) {
            this.myFields.add(f);
            if (obj.isFinal()) {
                this.finalFields.add(f);
            }
        }
    }

    public void visit(ConstantValue obj) {
        FieldAnnotation f = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
        this.constantFields.add(f);
    }

    public void visit(Code obj) {
        this.count_aload_1 = 0;
        this.previousOpcode = -1;
        this.previousPreviousOpcode = -1;
        this.nullTested.clear();
        this.seenInvokeStatic = false;
        this.opcodeStack.resetForMethodEntry((PreorderVisitor)this);
        this.staticFieldsReadInThisMethod.clear();
        super.visit(obj);
        if (this.getMethodName().equals("<init>") && this.count_aload_1 > 1 && (this.getClassName().indexOf(36) >= 0 || this.getClassName().indexOf(43) >= 0)) {
            this.needsOuterObjectInConstructor.add(this.getDottedClassName());
        }
    }

    public void visit(Method obj) {
        if (this.getMethodName().equals("<init>") && (obj.isPublic() || obj.isProtected())) {
            this.publicOrProtectedConstructor = true;
        }
        super.visit(obj);
        int flags = obj.getAccessFlags();
        if ((flags & 0x100) != 0) {
            this.hasNativeMethods = true;
        }
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        FieldAnnotation f;
        FieldAnnotation f2;
        if (seen == 178) {
            f2 = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
            this.staticFieldsReadInThisMethod.add(f2);
        } else if (seen == 184) {
            this.seenInvokeStatic = true;
        } else if (seen == 179 && !this.getMethod().isStatic() && !this.staticFieldsReadInThisMethod.contains(f2 = FieldAnnotation.fromReferencedField((DismantleBytecode)this))) {
            int priority = 3;
            if (!this.publicOrProtectedConstructor) {
                --priority;
            }
            if (!this.seenInvokeStatic && this.staticFieldsReadInThisMethod.isEmpty()) {
                --priority;
            }
            if (this.getThisClass().isPublic() && this.getMethod().isPublic()) {
                --priority;
            }
            if (this.getThisClass().isPrivate() || this.getMethod().isPrivate()) {
                ++priority;
            }
            if (this.getClassName().indexOf(36) != -1) {
                ++priority;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", priority).addClassAndMethod((PreorderVisitor)this).addField(f2).addSourceLine((DismantleBytecode)this));
        }
        if (seen == 182 || seen == 185 || seen == 183) {
            String sig = this.getSigConstantOperand();
            Type[] argTypes = Type.getArgumentTypes((String)sig);
            int pos = argTypes.length;
            if (this.opcodeStack.getStackDepth() > pos) {
                boolean selfCall;
                OpcodeStack.Item item2 = this.opcodeStack.getStackItem(pos);
                if (DEBUG) {
                    System.out.println("In " + this.getFullyQualifiedMethodName() + " saw call on " + item2);
                }
                boolean superCall = seen == 183 && !this.getClassConstantOperand().equals(this.getClassName());
                boolean bl = selfCall = item2.getRegisterNumber() == 0 && !superCall;
                if (selfCall && this.getMethodName().equals("<init>")) {
                    this.sawSelfCallInConstructor = true;
                    if (DEBUG) {
                        System.out.println("Saw self call in " + this.getFullyQualifiedMethodName() + " to " + this.getClassConstantOperand() + "." + this.getNameConstantOperand());
                    }
                }
            }
        }
        if ((seen == 198 || seen == 199) && this.opcodeStack.getStackDepth() > 0 && (f = (item = this.opcodeStack.getStackItem(0)).getField()) != null) {
            this.nullTested.add(f);
            if (DEBUG) {
                System.out.println(f + " null checked in " + this.getFullyQualifiedMethodName());
            }
        }
        if (seen == 180 || seen == 182 || seen == 185 || seen == 183 || seen == 181 || seen == 46 || seen == 79) {
            OpcodeStack.Item item3;
            FieldAnnotation f3;
            int pos = 0;
            switch (seen) {
                case 180: {
                    pos = 0;
                    break;
                }
                case 182: 
                case 183: 
                case 185: {
                    String sig = this.getSigConstantOperand();
                    Type[] argTypes = Type.getArgumentTypes((String)sig);
                    pos = argTypes.length;
                    break;
                }
                case 46: 
                case 79: 
                case 181: {
                    pos = 1;
                    break;
                }
                default: {
                    throw new RuntimeException("Impossible");
                }
            }
            if (!(this.opcodeStack.getStackDepth() <= pos || (f3 = (item3 = this.opcodeStack.getStackItem(pos)).getField()) == null || this.nullTested.contains(f3) || this.writtenInConstructorFields.contains(f3) && this.writtenNonNullFields.contains(f3))) {
                ProgramPoint p = new ProgramPoint((DismantleBytecode)this);
                HashSet<ProgramPoint> s = this.assumedNonNull.get(f3);
                if (s == null) {
                    s = new HashSet();
                    this.assumedNonNull.put(f3, s);
                }
                s.add(p);
                if (DEBUG) {
                    System.out.println(f3 + " assumed non-null in " + this.getFullyQualifiedMethodName());
                }
            }
        }
        if (seen == 43) {
            ++this.count_aload_1;
        } else if (seen == 180 || seen == 178) {
            f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
            if (DEBUG) {
                System.out.println("get: " + f);
            }
            this.readFields.add(f);
            if (this.getClassConstantOperand().equals(this.getClassName()) && !this.allMyFields.contains(f)) {
                this.superReadFields.add(this.getNameConstantOperand());
            }
        } else if (seen == 181 || seen == 179) {
            f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
            OpcodeStack.Item item4 = null;
            if (this.opcodeStack.getStackDepth() > 0 && !(item4 = this.opcodeStack.getStackItem(0)).isNull()) {
                this.nullTested.add(f);
            }
            this.writtenFields.add(f);
            if (this.previousOpcode != 1 || this.previousPreviousOpcode == 167) {
                this.writtenNonNullFields.add(f);
                if (DEBUG) {
                    System.out.println("put nn: " + f);
                }
            } else if (DEBUG) {
                System.out.println("put: " + f);
            }
            if (this.getMethodName().equals("<init>") || this.getMethodName().equals("<clinit>") || this.getMethod().isPrivate()) {
                this.writtenInConstructorFields.add(f);
                if (this.previousOpcode != 1 || this.previousPreviousOpcode == 167) {
                    this.assumedNonNull.remove(f);
                }
            }
            if (this.getClassConstantOperand().equals(this.getClassName()) && !this.allMyFields.contains(f)) {
                this.superWrittenFields.add(this.getNameConstantOperand());
            }
        }
        this.opcodeStack.sawOpcode((DismantleBytecode)this, seen);
        this.previousPreviousOpcode = this.previousOpcode;
        this.previousOpcode = seen;
        if (DEBUG) {
            System.out.println("After " + OPCODE_NAMES[seen] + " opcode stack is");
            System.out.println(this.opcodeStack);
        }
    }

    public void report() {
        int priority;
        String fieldSignature;
        String className;
        String fieldName;
        FieldAnnotation f;
        TreeSet<FieldAnnotation> notInitializedInConstructors = new TreeSet<FieldAnnotation>(this.declaredFields);
        notInitializedInConstructors.retainAll(this.readFields);
        notInitializedInConstructors.retainAll(this.writtenFields);
        notInitializedInConstructors.retainAll(this.assumedNonNull.keySet());
        notInitializedInConstructors.removeAll(this.writtenInConstructorFields);
        TreeSet<FieldAnnotation> readOnlyFields = new TreeSet<FieldAnnotation>(this.declaredFields);
        readOnlyFields.removeAll(this.writtenFields);
        readOnlyFields.retainAll(this.readFields);
        TreeSet<FieldAnnotation> nullOnlyFields = new TreeSet<FieldAnnotation>(this.declaredFields);
        nullOnlyFields.removeAll(this.writtenNonNullFields);
        nullOnlyFields.retainAll(this.readFields);
        Set<FieldAnnotation> writeOnlyFields = this.declaredFields;
        writeOnlyFields.removeAll(this.readFields);
        Iterator<FieldAnnotation> i = notInitializedInConstructors.iterator();
        while (i.hasNext()) {
            f = i.next();
            fieldName = f.getFieldName();
            className = f.getClassName();
            fieldSignature = f.getFieldSignature();
            if (this.superWrittenFields.contains(fieldName) || this.fieldsOfSerializableOrNativeClassed.contains(f) || fieldSignature.charAt(0) != 'L' && fieldSignature.charAt(0) != '[') continue;
            priority = 3;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", priority).addClass(className).addField(f));
        }
        i = readOnlyFields.iterator();
        while (i.hasNext()) {
            f = i.next();
            fieldName = f.getFieldName();
            className = f.getClassName();
            fieldSignature = f.getFieldSignature();
            if (this.superWrittenFields.contains(fieldName) || this.fieldsOfSerializableOrNativeClassed.contains(f)) continue;
            priority = 2;
            if (fieldSignature.charAt(0) != 'L' && fieldSignature.charAt(0) != '[') {
                ++priority;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "UWF_UNWRITTEN_FIELD", priority).addClass(className).addField(f));
        }
        i = nullOnlyFields.iterator();
        while (i.hasNext()) {
            f = i.next();
            fieldName = f.getFieldName();
            className = f.getClassName();
            fieldSignature = f.getFieldSignature();
            if (DEBUG) {
                System.out.println("Null only: " + f);
                System.out.println("   : " + this.assumedNonNull.containsKey(f));
            }
            if (this.superWrittenFields.contains(fieldName) || this.fieldsOfSerializableOrNativeClassed.contains(f)) continue;
            priority = 2;
            if (this.assumedNonNull.containsKey(f)) {
                priority = 1;
                Iterator<ProgramPoint> i$ = this.assumedNonNull.get(f).iterator();
                while (i$.hasNext()) {
                    ProgramPoint p = i$.next();
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NP_UNWRITTEN_FIELD", 2).addClassAndMethod(p.method).addSourceLine(p.sourceLine));
                }
            }
            if (readOnlyFields.contains(f)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "UWF_NULL_FIELD", priority).addClass(className).addField(f));
        }
        i = writeOnlyFields.iterator();
        while (i.hasNext()) {
            boolean isAnonymousInnerClass;
            f = i.next();
            fieldName = f.getFieldName();
            className = f.getClassName();
            int lastDollar = Math.max(className.lastIndexOf(36), className.lastIndexOf(43));
            boolean bl = isAnonymousInnerClass = lastDollar > 0 && lastDollar < className.length() - 1 && Character.isDigit(className.charAt(className.length() - 1));
            if (DEBUG) {
                System.out.println("Checking write only field " + className + "." + fieldName + "\t" + this.superReadFields.contains(fieldName) + "\t" + this.constantFields.contains(f) + "\t" + f.isStatic());
            }
            if (this.superReadFields.contains(fieldName) || this.dontComplainAbout.matcher(fieldName).find()) continue;
            if (fieldName.startsWith("this$") || fieldName.startsWith("this+")) {
                boolean easyChange;
                if (this.innerClassCannotBeStatic.contains(className)) continue;
                boolean bl2 = easyChange = !this.needsOuterObjectInConstructor.contains(className);
                if (!easyChange && isAnonymousInnerClass) continue;
                int priority2 = 3;
                if (easyChange && !isAnonymousInnerClass) {
                    priority2 = 2;
                }
                String bug = "SIC_INNER_SHOULD_BE_STATIC";
                if (isAnonymousInnerClass) {
                    bug = "SIC_INNER_SHOULD_BE_STATIC_ANON";
                } else if (!easyChange) {
                    bug = "SIC_INNER_SHOULD_BE_STATIC_NEEDS_THIS";
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, bug, priority2).addClass(className));
                continue;
            }
            if (this.constantFields.contains(f)) {
                if (f.isStatic()) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SS_SHOULD_BE_STATIC", 2).addClass(className).addField(f));
                continue;
            }
            if (this.fieldsOfSerializableOrNativeClassed.contains(f)) continue;
            if (!this.writtenFields.contains(f) && !this.superWrittenFields.contains(fieldName)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "UUF_UNUSED_FIELD", 2).addClass(className).addField(f));
                continue;
            }
            if (f.isStatic() && this.finalFields.contains(f)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "URF_UNREAD_FIELD", 2).addClass(className).addField(f));
        }
    }

    static class ProgramPoint {
        MethodAnnotation method;
        SourceLineAnnotation sourceLine;

        ProgramPoint(DismantleBytecode v) {
            this.method = MethodAnnotation.fromVisitedMethod((PreorderVisitor)v);
            this.sourceLine = SourceLineAnnotation.fromVisitedInstruction((PreorderVisitor)v, (int)v.getPC());
        }
    }
}

