/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BadSyntaxForRegularExpression
extends BytecodeScanningDetector
implements StatelessDetector {
    BugReporter bugReporter;
    OpcodeStack stack = new OpcodeStack();

    public BadSyntaxForRegularExpression(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
    }

    public void visit(Code obj) {
        this.stack.resetForMethodEntry((PreorderVisitor)this);
        super.visit(obj);
    }

    private void sawRegExPattern(int stackDepth) {
        if (this.stack.getStackDepth() < stackDepth) {
            return;
        }
        OpcodeStack.Item it = this.stack.getStackItem(stackDepth);
        Object value = it.getConstant();
        if (value == null || !(value instanceof String)) {
            return;
        }
        String regex = (String)value;
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "RE_BAD_SYNTAX_FOR_REGULAR_EXPRESSION", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("compile") && this.getSigConstantOperand().startsWith("(Ljava/lang/String;I)")) {
            this.sawRegExPattern(1);
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("compile") && this.getSigConstantOperand().startsWith("(Ljava/lang/String;)")) {
            this.sawRegExPattern(0);
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("matches")) {
            this.sawRegExPattern(1);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("replaceAll")) {
            this.sawRegExPattern(1);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("replaceFirst")) {
            this.sawRegExPattern(1);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("matches")) {
            this.sawRegExPattern(0);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("split")) {
            this.sawRegExPattern(0);
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

