/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import java.io.File;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class DumbMethodInvocations
implements Detector {
    private BugReporter bugReporter;

    public DumbMethodInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        Method[] arr$ = methodList = classContext.getJavaClass().getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        ConstantDataflow constantDataflow = classContext.getConstantDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            String v;
            Constant operandValue;
            Location location = (Location)i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction iins = (InvokeInstruction)ins;
            ConstantFrame frame = constantDataflow.getFactAtLocation(location);
            if (!frame.isValid()) continue;
            if (iins.getName(cpg).equals("substring") && iins.getSignature(cpg).equals("(I)Ljava/lang/String;") && iins.getClassName(cpg).equals("java.lang.String")) {
                int v2;
                operandValue = (Constant)frame.getTopValue();
                if (!operandValue.isConstantInteger() || (v2 = operandValue.getConstantInt()) != 0) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_USELESS_SUBSTRING", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)location.getHandle())));
                continue;
            }
            if (!iins.getName(cpg).equals("<init>") || !iins.getSignature(cpg).equals("(Ljava/lang/String;)V") || !iins.getClassName(cpg).equals("java.io.File") || !(operandValue = (Constant)frame.getTopValue()).isConstantString() || !this.isAbsoluteFileName(v = operandValue.getConstantString())) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_HARDCODED_ABSOLUTE_FILENAME", 2).addClassAndMethod(methodGen, sourceFile).addString(v).describe("FileName").addSourceLine(SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)location.getHandle())));
        }
    }

    private boolean isAbsoluteFileName(String v) {
        if (v.startsWith("/")) {
            return true;
        }
        if (v.startsWith("C:")) {
            return true;
        }
        if (v.startsWith("c:")) {
            return true;
        }
        try {
            File f = new File(v);
            return f.isAbsolute();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void report() {
    }
}

