/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;

public class FindBadForLoop
extends BytecodeScanningDetector
implements StatelessDetector {
    OpcodeStack stack = new OpcodeStack();
    BugReporter bugReporter;
    LineNumberTable lineNumbers;
    int lastRegStore;

    public FindBadForLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
    }

    public void visit(Code obj) {
        this.lastRegStore = -1;
        this.lineNumbers = obj.getLineNumberTable();
        this.stack.resetForMethodEntry((PreorderVisitor)this);
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        try {
            if (seen == 54 || seen == 59 || seen == 60 || seen == 61 || seen == 62) {
                this.lastRegStore = this.getRegisterOperand();
            }
            if (this.lineNumbers != null && this.stack.getStackDepth() >= 2 && (seen == 162 || seen == 163 || seen == 161 || seen == 164 || seen == 160 || seen == 159)) {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                int r0 = item0.getRegisterNumber();
                int r1 = item1.getRegisterNumber();
                int rMin = Math.min(r0, r1);
                int rMax = Math.max(r0, r1);
                int branchTarget = this.getBranchTarget();
                if (rMin == -1 && rMax > 0 && rMax == this.lastRegStore && branchTarget - 6 > this.getPC()) {
                    int beforeTarget = this.getCodeByte(branchTarget - 3);
                    int beforeGoto = this.getCodeByte(branchTarget - 6);
                    if (beforeTarget == 167 && beforeGoto == 132) {
                        byte offset1 = (byte)this.getCodeByte(branchTarget - 2);
                        int offset2 = this.getCodeByte(branchTarget - 1);
                        int offset = offset1 << 8 | offset2;
                        int backTarget = branchTarget - 3 + offset;
                        int reg = this.getCodeByte(branchTarget - 5);
                        int testLineNumber = this.lineNumbers.getSourceLine(this.getPC());
                        int incLineNumber = this.lineNumbers.getSourceLine(branchTarget - 6);
                        int beforeIncLineNumber = this.lineNumbers.getSourceLine(branchTarget - 7);
                        if (backTarget < this.getPC() && this.getPC() - 8 < backTarget && reg != rMax && incLineNumber < testLineNumber + 3 && beforeIncLineNumber > incLineNumber) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "QF_QUESTIONABLE_FOR_LOOP", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                }
            }
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
        catch (RuntimeException e) {
            System.out.println("Exception at " + this.getPC() + " in " + this.getFullyQualifiedMethodName());
            e.printStackTrace(System.out);
        }
    }
}

