/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.MethodGen;

public class FindSqlInjection
implements Detector {
    BugReporter bugReporter;

    public FindSqlInjection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private boolean prescreen(ClassContext classContext, Method method) {
        return true;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] arr$ = methodList = javaClass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !this.prescreen(classContext, method)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("FindDeadLocalStores caught exception while analyzing " + methodGen, (Throwable)e);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("FindDeadLocalStores caught exception while analyzing " + methodGen, (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        JavaClass javaClass = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        ConstantPoolGen cpg = methodGen.getConstantPool();
        try {
            CFG cfg = classContext.getCFG(method);
            ConstantDataflow dataflow = classContext.getConstantDataflow(method);
            Iterator i = cfg.locationIterator();
            while (i.hasNext()) {
                ConstantFrame frame;
                Constant value;
                Location location = (Location)i.next();
                Instruction ins = location.getHandle().getInstruction();
                if (!(ins instanceof INVOKEINTERFACE)) continue;
                INVOKEINTERFACE invoke = (INVOKEINTERFACE)ins;
                String methodName = invoke.getMethodName(cpg);
                String interfaceName = invoke.getClassName(cpg);
                if ((!methodName.equals("prepareStatement") || !interfaceName.equals("java.sql.Connection")) && (!methodName.startsWith("execute") || !interfaceName.equals("java.sql.Statement")) || (value = (Constant)(frame = dataflow.getFactAtLocation(location)).getStackValue(0)).isConstantString()) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, methodName.equals("prepareStatement") ? "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING" : "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE", 2).addClassAndMethod(methodGen, javaClass.getSourceFileName()).addSourceLine(classContext, methodGen, javaClass.getSourceFileName(), location.getHandle()));
            }
        }
        catch (RuntimeException e) {
            System.out.println("Exception while checking for SQL injection in " + methodGen + " in " + javaClass.getSourceFileName());
            e.printStackTrace(System.out);
        }
    }

    public void report() {
    }
}

