/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InfiniteRecursiveLoop
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    private boolean seenTransferOfControl;
    private boolean seenReturn;
    private boolean seenThrow;
    private boolean seenStateChange;
    private int largestBranchTarget;
    private static final boolean DEBUG = Boolean.getBoolean("irl.debug");
    int parameters;
    OpcodeStack stack = new OpcodeStack();

    public InfiniteRecursiveLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
        this.seenTransferOfControl = false;
        this.seenStateChange = false;
        this.seenReturn = false;
        this.seenThrow = false;
        this.largestBranchTarget = -1;
        this.parameters = this.stack.resetForMethodEntry((PreorderVisitor)this);
        if (DEBUG) {
            System.out.println();
            System.out.println(" --- " + this.getFullyQualifiedMethodName());
            System.out.println();
        }
    }

    public void sawBranchTo(int seen) {
        if (this.largestBranchTarget < seen) {
            this.largestBranchTarget = seen;
        }
        this.seenTransferOfControl = true;
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item it1;
        int r1;
        OpcodeStack.Item it0;
        int r0;
        if (this.seenReturn && this.seenTransferOfControl && this.seenStateChange) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.stack);
            System.out.println(this.getPC() + " : " + OPCODE_NAMES[seen]);
        }
        if ((seen == 182 || seen == 185) && this.getNameConstantOperand().equals("add") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") && this.stack.getStackDepth() >= 2 && (r0 = (it0 = this.stack.getStackItem(0)).getRegisterNumber()) == (r1 = (it1 = this.stack.getStackItem(1)).getRegisterNumber()) && r0 > 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "IL_CONTAINER_ADDED_TO_ITSELF", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if ((seen == 182 || seen == 183 || seen == 185 || seen == 184) && this.getNameConstantOperand().equals(this.getMethodName()) && this.getSigConstantOperand().equals(this.getMethodSig()) && seen == 184 == this.getMethod().isStatic() && this.stack.getStackDepth() >= this.parameters) {
            if (DEBUG) {
                System.out.println("IL: Checking...");
                System.out.println(this.getClassConstantOperand() + "." + this.getNameConstantOperand() + " : " + this.getSigConstantOperand());
                System.out.println("vs. " + this.getClassName() + "." + this.getMethodName() + " : " + this.getMethodSig());
            }
            if (this.getClassConstantOperand().equals(this.getClassName()) || seen == 182 || seen == 185) {
                boolean match3;
                boolean sameMethod;
                int firstParameter = 0;
                if (this.getMethodName().equals("<init>")) {
                    firstParameter = 1;
                }
                boolean match1 = !this.seenStateChange;
                for (int i = firstParameter; match1 && i < this.parameters; ++i) {
                    OpcodeStack.Item it = this.stack.getStackItem(this.parameters - 1 - i);
                    if (it.isInitialParameter() && it.getRegisterNumber() == i) continue;
                    match1 = false;
                }
                boolean bl = sameMethod = seen == 184 || this.getNameConstantOperand().equals("<init>");
                if (!sameMethod) {
                    OpcodeStack.Item p = this.stack.getStackItem(this.parameters - 1);
                    sameMethod = p.isInitialParameter() && p.getRegisterNumber() == 0;
                }
                boolean match2 = sameMethod && !this.seenTransferOfControl;
                boolean bl2 = match3 = sameMethod && !this.seenReturn && this.largestBranchTarget < this.getPC();
                if (match1 || match2 || match3) {
                    if (DEBUG) {
                        System.out.println("IL: " + match1 + " " + match2 + " " + match3);
                    }
                    int priority = 1;
                    if (!match1 && !match2 && this.seenThrow) {
                        priority = 2;
                    }
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "IL_INFINITE_RECURSIVE_LOOP", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
        switch (seen) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                this.seenReturn = true;
                this.seenTransferOfControl = true;
                break;
            }
            case 191: {
                this.seenThrow = true;
                this.seenTransferOfControl = true;
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 179: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.seenStateChange = true;
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

