/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class InvalidJUnitTest
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_ALOAD_0 = 1;
    private BugReporter bugReporter;
    private int state;
    boolean directChildOfTestCase;
    private boolean sawSuperCall;

    public InvalidJUnitTest(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass jClass = classContext.getJavaClass();
        try {
            if (!Repository.instanceOf((JavaClass)jClass, (String)"junit.framework.TestCase")) {
                return;
            }
            if ((jClass.getAccessFlags() & 0x400) == 0) {
                Method[] methods = jClass.getMethods();
                boolean foundTest = false;
                Method[] arr$ = methods;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Method m = arr$[i$];
                    if (!m.getName().startsWith("test")) continue;
                    foundTest = true;
                    break;
                }
                if (!foundTest) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "IJU_NO_TESTS", 3).addClass(jClass));
                }
            }
            JavaClass superClass = jClass.getSuperClass();
            this.directChildOfTestCase = superClass.getClassName().equals("junit.framework.TestCase");
            jClass.accept((Visitor)this);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void visit(Method obj) {
        if (this.getMethodName().equals("suite") && !obj.isStatic()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "IJU_SUITE_NOT_STATIC", 2).addClassAndMethod((PreorderVisitor)this));
        }
    }

    public void visit(Code obj) {
        if (!this.directChildOfTestCase && (this.getMethodName().equals("setUp") || this.getMethodName().equals("tearDown"))) {
            this.sawSuperCall = false;
            super.visit(obj);
            if (this.sawSuperCall) {
                return;
            }
            JavaClass we = Lookup.findSuperImplementor((JavaClass)this.getThisClass(), (String)this.getMethodName(), (String)"()V", (BugReporter)this.bugReporter);
            if (we != null && !we.getClassName().equals("junit.framework.TestCase")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, this.getMethodName().equals("setUp") ? "IJU_SETUP_NO_SUPER" : "IJU_TEARDOWN_NO_SUPER", 2).addClassAndMethod((PreorderVisitor)this));
            }
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen != 42) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 183 && this.getNameConstantOperand().equals(this.getMethodName()) && this.getMethodSig().equals("()V")) {
                    this.sawSuperCall = true;
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }
}

