/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class IteratorIdioms
extends BytecodeScanningDetector
implements StatelessDetector {
    private JavaClass iteratorClass;
    private BugReporter bugReporter;
    boolean sawNoSuchElement;

    public IteratorIdioms(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitClassContext(ClassContext classContext) {
        this.findJavaUtilIterator();
        if (this.iteratorClass == null) {
            return;
        }
        try {
            JavaClass cls = classContext.getJavaClass();
            if (cls.implementationOf(this.iteratorClass)) {
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void findJavaUtilIterator() {
        if (this.iteratorClass == null) {
            try {
                this.iteratorClass = Repository.lookupClass((String)"java.util.Iterator");
            }
            catch (ClassNotFoundException cnfe) {
                this.iteratorClass = null;
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals("next") && this.getMethodSig().equals("()Ljava/lang/Object;")) {
            this.sawNoSuchElement = false;
            super.visit(obj);
            if (!this.sawNoSuchElement) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "IT_NO_SUCH_ELEMENT", 2).addClassAndMethod((PreorderVisitor)this));
            }
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 187 && this.getClassConstantOperand().equals("java/util/NoSuchElementException")) {
            this.sawNoSuchElement = true;
        } else if ((seen == 183 || seen == 182 || seen == 185) && this.getNameConstantOperand().indexOf("next") >= 0) {
            this.sawNoSuchElement = true;
        }
    }
}

