/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class PreferZeroLengthArrays
extends BytecodeScanningDetector
implements StatelessDetector {
    boolean nullOnTOS = false;
    private BugReporter bugReporter;

    public PreferZeroLengthArrays(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Code obj) {
        String returnType = this.getMethodSig().substring(this.getMethodSig().indexOf(")") + 1);
        if (returnType.startsWith("[")) {
            this.nullOnTOS = false;
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 1: {
                this.nullOnTOS = true;
                return;
            }
            case 176: {
                if (!this.nullOnTOS) break;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "PZLA_PREFER_ZERO_LENGTH_ARRAYS", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.getPC()));
            }
        }
        this.nullOnTOS = false;
    }
}

