/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.InstructionHandle;

public class RuntimeExceptionCapture
extends BytecodeScanningDetector
implements Detector,
StatelessDetector {
    private static final boolean DEBUG = Boolean.getBoolean("rec.debug");
    private BugReporter bugReporter;
    private Method method;
    private OpcodeStack stack = new OpcodeStack();
    private List<ExceptionCaught> catchList;
    private List<ExceptionThrown> throwList;

    public RuntimeExceptionCapture(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitMethod(Method method) {
        this.method = method;
        if (DEBUG) {
            System.out.println("RuntimeExceptionCapture visiting " + method);
        }
        super.visitMethod(method);
    }

    public void visitCode(Code obj) {
        this.catchList = new ArrayList<ExceptionCaught>();
        this.throwList = new ArrayList<ExceptionThrown>();
        this.stack.resetForMethodEntry((PreorderVisitor)this);
        super.visitCode(obj);
        Iterator<ExceptionCaught> i$ = this.catchList.iterator();
        while (i$.hasNext()) {
            ExceptionCaught caughtException = i$.next();
            HashSet<String> thrownSet = new HashSet<String>();
            Iterator<ExceptionThrown> i$2 = this.throwList.iterator();
            while (i$2.hasNext()) {
                ExceptionThrown thrownException = i$2.next();
                if (thrownException.offset < caughtException.startOffset || thrownException.offset >= caughtException.endOffset) continue;
                thrownSet.add(thrownException.exceptionClass);
                if (!thrownException.exceptionClass.equals(caughtException.exceptionClass)) continue;
                caughtException.seen = true;
            }
            int catchClauses = 0;
            if (!caughtException.exceptionClass.equals("java.lang.Exception") || caughtException.seen) continue;
            boolean rteCaught = false;
            Iterator<ExceptionCaught> i$3 = this.catchList.iterator();
            while (i$3.hasNext()) {
                ExceptionCaught otherException = i$3.next();
                if (otherException.startOffset != caughtException.startOffset || otherException.endOffset != caughtException.endOffset) continue;
                ++catchClauses;
                if (!otherException.exceptionClass.equals("java.lang.RuntimeException")) continue;
                rteCaught = true;
            }
            int range = caughtException.endOffset - caughtException.startOffset;
            if (rteCaught) continue;
            int priority = 4;
            if (range > 300) {
                --priority;
            } else if (range < 30) {
                ++priority;
            }
            if (catchClauses > 1) {
                ++priority;
            }
            if (thrownSet.size() > 1) {
                --priority;
            }
            if (caughtException.dead) {
                --priority;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "REC_CATCH_EXCEPTION", priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, caughtException.sourcePC));
        }
    }

    public void visit(CodeException obj) {
        super.visit(obj);
        int type = obj.getCatchType();
        if (type == 0) {
            return;
        }
        String name = this.getConstantPool().constantToString(this.getConstantPool().getConstant(type));
        ExceptionCaught caughtException = new ExceptionCaught(name, obj.getStartPC(), obj.getEndPC(), obj.getHandlerPC());
        this.catchList.add(caughtException);
        try {
            LiveLocalStoreDataflow dataflow = this.getClassContext().getLiveLocalStoreDataflow(this.method);
            CFG cfg = this.getClassContext().getCFG(this.method);
            Collection blockList = cfg.getBlocksContainingInstructionWithOffset(obj.getHandlerPC());
            Iterator i$ = blockList.iterator();
            while (i$.hasNext()) {
                BasicBlock block = (BasicBlock)i$.next();
                InstructionHandle first = block.getFirstInstruction();
                if (first == null || first.getPosition() != obj.getHandlerPC() || !(first.getInstruction() instanceof ASTORE)) continue;
                ASTORE astore = (ASTORE)first.getInstruction();
                BitSet liveStoreSet = dataflow.getFactAtLocation(new Location(first, block));
                if (liveStoreSet.get(astore.getIndex())) continue;
                if (DEBUG) {
                    System.out.println("Dead exception store at " + first);
                }
                caughtException.dead = true;
                break;
            }
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("Error checking for dead exception store", (Throwable)e);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Error checking for dead exception store", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            switch (seen) {
                case 191: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    String signature = item.getSignature();
                    if (signature == null) return;
                    if (signature.length() <= 0) return;
                    signature = signature.startsWith("L") ? SignatureConverter.convert((String)signature) : signature.replace('/', '.');
                    this.throwList.add(new ExceptionThrown(signature, this.getPC()));
                    return;
                }
                case 182: 
                case 183: 
                case 184: {
                    String className = this.getDottedClassConstantOperand();
                    try {
                        Method[] methods;
                        if (className.startsWith("[")) return;
                        JavaClass clazz = Repository.lookupClass((String)className);
                        Method[] arr$ = methods = clazz.getMethods();
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (i$ < len$) {
                            Method method = arr$[i$];
                            if (method.getName().equals(this.getNameConstantOperand()) && method.getSignature().equals(this.getSigConstantOperand())) {
                                String[] names;
                                ExceptionTable et = method.getExceptionTable();
                                if (et == null) return;
                                String[] arr$2 = names = et.getExceptionNames();
                                int len$2 = arr$2.length;
                                int i$2 = 0;
                                while (i$2 < len$2) {
                                    String name = arr$2[i$2];
                                    this.throwList.add(new ExceptionThrown(name, this.getPC()));
                                    ++i$2;
                                }
                                break block9;
                                return;
                            }
                            ++i$;
                        }
                        return;
                    }
                    catch (ClassNotFoundException e) {
                        this.bugReporter.reportMissingClass(e);
                        return;
                    }
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static class ExceptionThrown {
        public String exceptionClass;
        public int offset;

        public ExceptionThrown(String exceptionClass, int offset) {
            this.exceptionClass = exceptionClass;
            this.offset = offset;
        }
    }

    private static class ExceptionCaught {
        public String exceptionClass;
        public int startOffset;
        public int endOffset;
        public int sourcePC;
        public boolean seen = false;
        public boolean dead = false;

        public ExceptionCaught(String exceptionClass, int startOffset, int endOffset, int sourcePC) {
            this.exceptionClass = exceptionClass;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.sourcePC = sourcePC;
        }
    }
}

