/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class StartInConstructor
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    boolean isFinal;

    public StartInConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
        this.isFinal = (obj.getAccessFlags() & 0x10) != 0 || (obj.getAccessFlags() & 1) == 0;
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals("<init>")) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (!this.isFinal && seen == 182 && this.getNameConstantOperand().equals("start") && this.getSigConstantOperand().equals("()V")) {
            try {
                if (Hierarchy.isSubtype((String)this.getDottedClassConstantOperand(), (String)"java.lang.Thread")) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SC_START_IN_CTOR", 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }
}

