/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyze {
    private static JavaClass serializable;
    private static JavaClass collection;
    private static JavaClass map;
    private static JavaClass remote;
    private static ClassNotFoundException storedException;

    private static boolean containsConcreteClasses(Set<JavaClass> s) {
        for (JavaClass c : s) {
            if (c.isInterface() || c.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public static double isDeepSerializable(String refSig) throws ClassNotFoundException {
        if (storedException != null) {
            throw storedException;
        }
        if (Analyze.isPrimitiveComponentClass(refSig)) {
            return 1.0;
        }
        String refName = Analyze.getComponentClass(refSig);
        if (refName.equals("java.lang.Object")) {
            return 0.99;
        }
        JavaClass refJavaClass = Repository.lookupClass((String)refName);
        return Analyze.isDeepSerializable(refJavaClass);
    }

    public static double isDeepRemote(String refSig) {
        if (remote == null) {
            return 0.1;
        }
        String refName = Analyze.getComponentClass(refSig);
        if (refName.equals("java.lang.Object")) {
            return 0.99;
        }
        try {
            JavaClass refJavaClass = Repository.lookupClass((String)refName);
            return Analyze.deepInstanceOf(refJavaClass, remote);
        }
        catch (ClassNotFoundException e) {
            return 0.99;
        }
    }

    private static boolean isPrimitiveComponentClass(String refSig) {
        int c;
        for (c = 0; c < refSig.length() && refSig.charAt(c) == '['; ++c) {
        }
        return c >= refSig.length() || refSig.charAt(c) != 'L';
    }

    public static String getComponentClass(String refSig) {
        while (refSig.charAt(0) == '[') {
            refSig = refSig.substring(1);
        }
        if (refSig.charAt(0) == 'L') {
            return refSig.substring(1, refSig.length() - 1).replace('/', '.');
        }
        return refSig;
    }

    public static double isDeepSerializable(JavaClass x) throws ClassNotFoundException {
        if (storedException != null) {
            throw storedException;
        }
        double result = Analyze.deepInstanceOf(x, serializable);
        if (result >= 0.9) {
            return result;
        }
        if ((result = Math.max(result, Analyze.deepInstanceOf(x, collection))) >= 0.9) {
            return result;
        }
        result = Math.max(result, Analyze.deepInstanceOf(x, map));
        return result;
    }

    public static double deepInstanceOf(JavaClass x, JavaClass y) throws ClassNotFoundException {
        if (x.equals((Object)y)) {
            return 1.0;
        }
        boolean xIsSubtypeOfY = Repository.instanceOf((JavaClass)x, (JavaClass)y);
        if (xIsSubtypeOfY) {
            return 1.0;
        }
        boolean yIsSubtypeOfX = Repository.instanceOf((JavaClass)y, (JavaClass)x);
        if (!yIsSubtypeOfX) {
            if (x.isFinal() || y.isFinal()) {
                return 0.0;
            }
            if (!x.isInterface() && !y.isInterface()) {
                return 0.0;
            }
        }
        Subtypes subtypes = AnalysisContext.currentAnalysisContext().getSubtypes();
        subtypes.addClass(x);
        subtypes.addClass(y);
        Set xSubtypes = subtypes.getTransitiveSubtypes(x);
        Set ySubtypes = subtypes.getTransitiveSubtypes(y);
        HashSet both = new HashSet(xSubtypes);
        both.retainAll(ySubtypes);
        HashSet<JavaClass> xButNotY = new HashSet<JavaClass>(xSubtypes);
        xButNotY.removeAll(ySubtypes);
        boolean concreteClassesInXButNotY = Analyze.containsConcreteClasses(xButNotY);
        if (both.isEmpty()) {
            if (concreteClassesInXButNotY) {
                return 0.1;
            }
            return 0.3;
        }
        if (!concreteClassesInXButNotY) {
            return 0.99;
        }
        return 0.7;
    }

    static {
        try {
            serializable = Repository.lookupClass((String)"java.io.Serializable");
            collection = Repository.lookupClass((String)"java.util.Collection");
            map = Repository.lookupClass((String)"java.util.Map");
        }
        catch (ClassNotFoundException e) {
            storedException = e;
        }
        try {
            remote = Repository.lookupClass((String)"java.rmi.Remote");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

